/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.idea.actions.EditMultipleSourcesAction;
import com.android.tools.idea.actions.PsiFileAndLineNavigation;
import com.android.tools.idea.editors.allocations.ColumnTreeBuilder;
import com.android.tools.idea.editors.hprof.views.SelectionModel;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapClassObjNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapPackageNode;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class ClassesTreeView
implements DataProvider,
Disposable {
    public static final String TREE_NAME = "HprofClassesTree";
    private Project myProject;
    private Tree myTree;
    private DefaultTreeModel myTreeModel;
    private HeapPackageNode myRoot;
    private JComponent myColumnTree;
    private Comparator<HeapNode> myComparator;
    private int mySelectedHeapId;
    private ListIndex myListIndex;
    private TreeIndex myTreeIndex;
    private DisplayMode myDisplayMode;

    public ClassesTreeView(Project project, DefaultActionGroup editorActionGroup, final SelectionModel selectionModel) {
        this.myProject = project;
        this.myRoot = new HeapPackageNode(null, "");
        this.myTreeModel = new DefaultTreeModel(this.myRoot);
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setName(TREE_NAME);
        this.myDisplayMode = DisplayMode.LIST;
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        this.myTree.setLargeModel(true);
        this.myTree.putClientProperty((Object)"DataProvider", (Object)this);
        JBList contextActionList = new JBList(new Object[]{new EditMultipleSourcesAction()});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)contextActionList);
        final DefaultActionGroup popupGroup = new DefaultActionGroup(new AnAction[]{new EditMultipleSourcesAction()});
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }
        });
        editorActionGroup.addAction((AnAction)new ComboBoxAction(){

            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                for (final DisplayMode mode : DisplayMode.values()) {
                    group.add(new AnAction(mode.toString()){

                        public void actionPerformed(AnActionEvent e) {
                            ClassesTreeView.this.myDisplayMode = mode;
                            boolean isTreeMode = ClassesTreeView.this.myDisplayMode == DisplayMode.TREE;
                            ClassesTreeView.this.myTree.setShowsRootHandles(isTreeMode);
                            if (isTreeMode) {
                                ClassesTreeView.this.myTreeIndex.buildTree(ClassesTreeView.this.mySelectedHeapId);
                            } else {
                                ClassesTreeView.this.myListIndex.buildList(ClassesTreeView.this.myRoot);
                            }
                            ClassesTreeView.this.restoreViewState(selectionModel);
                        }
                    });
                }
                return group;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                this.getTemplatePresentation().setText(ClassesTreeView.this.myDisplayMode.toString());
                e.getPresentation().setText(ClassesTreeView.this.myDisplayMode.toString());
            }
        });
        this.myListIndex = new ListIndex();
        this.myTreeIndex = new TreeIndex();
        selectionModel.addListener(this.myListIndex);
        selectionModel.addListener(this.myTreeIndex);
        selectionModel.addListener(new SelectionModel.SelectionListener(){

            @Override
            public void onHeapChanged(Heap heap) {
                ClassesTreeView.this.mySelectedHeapId = heap.getId();
                assert (ClassesTreeView.this.myListIndex.myHeapId == ClassesTreeView.this.mySelectedHeapId);
                if (ClassesTreeView.this.myDisplayMode == DisplayMode.LIST) {
                    ClassesTreeView.this.myListIndex.buildList(ClassesTreeView.this.myRoot);
                } else if (ClassesTreeView.this.myDisplayMode == DisplayMode.TREE) {
                    ClassesTreeView.this.myTreeIndex.buildTree(ClassesTreeView.this.mySelectedHeapId);
                }
                ClassesTreeView.this.restoreViewState(selectionModel);
            }

            @Override
            public void onClassObjChanged(ClassObj classObj) {
                HeapClassObjNode nodeToSelect = null;
                if (classObj != null) {
                    nodeToSelect = ClassesTreeView.this.findClassObjNode(classObj);
                }
                if (nodeToSelect != null) {
                    TreePath pathToSelect = new TreePath(ClassesTreeView.this.myTreeModel.getPathToRoot(nodeToSelect));
                    ClassesTreeView.this.myTree.setSelectionPath(pathToSelect);
                    ClassesTreeView.this.myTree.scrollPathToVisible(pathToSelect);
                }
            }

            @Override
            public void onInstanceChanged(Instance instance) {
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                if (!e.isAddedPath()) {
                    return;
                }
                if (path == null || path.getPathCount() < 2) {
                    selectionModel.setClassObj(null);
                    return;
                }
                assert (path.getLastPathComponent() instanceof HeapNode);
                HeapNode heapNode = (HeapNode)path.getLastPathComponent();
                if (heapNode instanceof HeapClassObjNode) {
                    selectionModel.setClassObj(((HeapClassObjNode)heapNode).getClassObj());
                }
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class Name").setPreferredWidth(800).setHeaderAlignment(2).setComparator(new Comparator<HeapNode>(){

            @Override
            public int compare(HeapNode a, HeapNode b) {
                int valueB;
                int valueA = a instanceof HeapPackageNode ? 0 : 1;
                int n = valueB = b instanceof HeapPackageNode ? 0 : 1;
                if (valueA != valueB) {
                    return valueA - valueB;
                }
                return ClassesTreeView.compareNames(a, b);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof HeapClassObjNode) {
                    ClassObj clazz = ((HeapClassObjNode)value).getClassObj();
                    String name = clazz.getClassName();
                    String pkg = null;
                    int i = name.lastIndexOf(".");
                    if (i != -1) {
                        pkg = name.substring(0, i);
                        name = name.substring(i + 1);
                    }
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (pkg != null) {
                        this.append(" (" + pkg + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                    }
                    this.setTransparentIconBackground(true);
                    this.setIcon(PlatformIcons.CLASS_ICON);
                } else if (value instanceof HeapNode) {
                    this.append(((HeapNode)value).getSimpleName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setTransparentIconBackground(true);
                    this.setIcon(PlatformIcons.PACKAGE_ICON);
                } else {
                    this.append("This should not be rendered");
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Total Count").setPreferredWidth(100).setHeaderAlignment(4).setComparator(new Comparator<HeapNode>(){

            @Override
            public int compare(HeapNode a, HeapNode b) {
                int result = a.getTotalCount() - b.getTotalCount();
                return result == 0 ? ClassesTreeView.compareNames(a, b) : result;
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof HeapNode) {
                    this.append(Integer.toString(((HeapNode)value).getTotalCount()));
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Heap Count").setPreferredWidth(100).setHeaderAlignment(4).setComparator(new Comparator<HeapNode>(){

            @Override
            public int compare(HeapNode a, HeapNode b) {
                int result = a.getHeapInstancesCount(ClassesTreeView.this.mySelectedHeapId) - b.getHeapInstancesCount(ClassesTreeView.this.mySelectedHeapId);
                return result == 0 ? ClassesTreeView.compareNames(a, b) : result;
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof HeapNode) {
                    this.append(Integer.toString(((HeapNode)value).getHeapInstancesCount(ClassesTreeView.this.mySelectedHeapId)));
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Sizeof").setPreferredWidth(80).setHeaderAlignment(4).setComparator(new Comparator<HeapNode>(){

            @Override
            public int compare(HeapNode a, HeapNode b) {
                int sizeA = a.getInstanceSize();
                int sizeB = b.getInstanceSize();
                if (sizeA < 0 && sizeB < 0) {
                    return ClassesTreeView.compareNames(a, b);
                }
                int result = sizeA - sizeB;
                return result == 0 ? ClassesTreeView.compareNames(a, b) : result;
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof HeapClassObjNode) {
                    this.append(Integer.toString(((HeapClassObjNode)value).getInstanceSize()));
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Shallow Size").setPreferredWidth(100).setHeaderAlignment(4).setComparator(new Comparator<HeapNode>(){

            @Override
            public int compare(HeapNode a, HeapNode b) {
                int result = a.getShallowSize(ClassesTreeView.this.mySelectedHeapId) - b.getShallowSize(ClassesTreeView.this.mySelectedHeapId);
                return result == 0 ? ClassesTreeView.compareNames(a, b) : result;
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof HeapNode) {
                    this.append(Integer.toString(((HeapNode)value).getShallowSize(ClassesTreeView.this.mySelectedHeapId)));
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Retained Size").setPreferredWidth(120).setHeaderAlignment(4).setInitialOrder(SortOrder.DESCENDING).setComparator(new Comparator<HeapNode>(){

            @Override
            public int compare(HeapNode a, HeapNode b) {
                long result = a.getRetainedSize() - b.getRetainedSize();
                return result == 0L ? ClassesTreeView.compareNames(a, b) : (result > 0L ? 1 : -1);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof HeapNode) {
                    this.append(Long.toString(((HeapNode)value).getRetainedSize()));
                }
                this.setTextAlign(4);
            }
        }));
        builder.setTreeSorter(new ColumnTreeBuilder.TreeSorter<HeapNode>(){

            @Override
            public void sort(Comparator<HeapNode> comparator, SortOrder sortOrder) {
                if (ClassesTreeView.this.myComparator != comparator) {
                    ClassesTreeView.this.myComparator = comparator;
                    selectionModel.setSelectionLocked(true);
                    TreePath selectionPath = ClassesTreeView.this.myTree.getSelectionPath();
                    ClassesTreeView.this.sortTree(ClassesTreeView.this.myRoot);
                    ClassesTreeView.this.myTreeModel.nodeStructureChanged(ClassesTreeView.this.myRoot);
                    ClassesTreeView.this.myTree.setSelectionPath(selectionPath);
                    ClassesTreeView.this.myTree.scrollPathToVisible(selectionPath);
                    selectionModel.setSelectionLocked(false);
                }
            }
        });
        this.myColumnTree = builder.build();
        this.installTreeSpeedSearch();
    }

    public JComponent getComponent() {
        return this.myColumnTree;
    }

    public void requestFocus() {
        this.myTree.requestFocus();
    }

    private void installTreeSpeedSearch() {
        new TreeSpeedSearch(this.myTree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath e) {
                Object o = e.getLastPathComponent();
                if (o instanceof HeapNode) {
                    if (o instanceof HeapClassObjNode) {
                        return ((HeapClassObjNode)o).getSimpleName();
                    }
                    if (o instanceof HeapPackageNode) {
                        return ((HeapPackageNode)o).getFullName();
                    }
                }
                return o.toString();
            }
        }, true);
    }

    private void sortTree(HeapPackageNode parent) {
        if (parent.isLeaf() || this.myComparator == null) {
            return;
        }
        List<HeapNode> children = parent.getChildren();
        Collections.sort(children, this.myComparator);
        for (HeapNode child : children) {
            if (!(child instanceof HeapPackageNode)) continue;
            this.sortTree((HeapPackageNode)child);
        }
    }

    private static int compareNames(HeapNode a, HeapNode b) {
        int comparisonResult = a.getSimpleName().compareToIgnoreCase(b.getSimpleName());
        if (comparisonResult == 0) {
            return a.getFullName().compareToIgnoreCase(b.getFullName());
        }
        return comparisonResult;
    }

    private void restoreViewState(SelectionModel selectionModel) {
        ClassObj classToSelect = selectionModel.getClassObj();
        HeapClassObjNode nodeToSelect = null;
        if (classToSelect != null) {
            nodeToSelect = this.findClassObjNode(classToSelect);
        }
        this.sortTree(this.myRoot);
        this.myTreeModel.nodeStructureChanged(this.myRoot);
        HeapClassObjNode targetNode = nodeToSelect;
        if (targetNode != null) {
            this.myColumnTree.revalidate();
            final TreePath pathToSelect = new TreePath(this.myTreeModel.getPathToRoot(targetNode));
            this.myTree.setSelectionPath(pathToSelect);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassesTreeView.this.myTree.scrollPathToVisible(pathToSelect);
                }
            });
        } else {
            selectionModel.setClassObj(null);
            if (this.myTree.getRowCount() > 0) {
                this.myTree.scrollRowToVisible(0);
            }
        }
    }

    private HeapClassObjNode findClassObjNode(ClassObj targetClass) {
        block8: {
            block7: {
                if (this.myDisplayMode != DisplayMode.LIST) break block7;
                for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                    TreeNode child = this.myRoot.getChildAt(i);
                    assert (child instanceof HeapClassObjNode);
                    if (((HeapClassObjNode)child).getClassObj() != targetClass) continue;
                    return (HeapClassObjNode)child;
                }
                break block8;
            }
            if (this.myDisplayMode != DisplayMode.TREE) break block8;
            HeapPackageNode currentNode = this.myRoot;
            String[] packages = targetClass.getClassName().split("\\.");
            assert (packages.length > 0);
            for (int currentPackageIndex = 0; currentPackageIndex < packages.length - 1; ++currentPackageIndex) {
                if (currentNode.getSubPackages().containsKey(packages[currentPackageIndex])) {
                    currentNode = currentNode.getSubPackages().get(packages[currentPackageIndex]);
                    continue;
                }
                return null;
            }
            for (int i = 0; i < currentNode.getChildCount(); ++i) {
                TreeNode childTreeNode = currentNode.getChildAt(i);
                assert (childTreeNode instanceof HeapNode);
                HeapNode child = (HeapNode)childTreeNode;
                if (!(child instanceof HeapClassObjNode) || ((HeapClassObjNode)child).getClassObj() != targetClass) continue;
                return (HeapClassObjNode)child;
            }
        }
        return null;
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getTargetFiles();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private PsiFileAndLineNavigation[] getTargetFiles() {
        TreePath path = this.myTree.getSelectionPath();
        if (path.getPathCount() < 2) {
            return null;
        }
        assert (path.getLastPathComponent() instanceof HeapNode);
        HeapNode node = (HeapNode)path.getLastPathComponent();
        if (node instanceof HeapClassObjNode) {
            ClassObj classObj = ((HeapClassObjNode)node).getClassObj();
            String className = classObj.getClassName();
            int arrayIndex = className.indexOf("[");
            if (arrayIndex >= 0) {
                className = className.substring(0, arrayIndex);
            }
            return PsiFileAndLineNavigation.wrappersForClassName(this.myProject, className, 1);
        }
        return null;
    }

    public void dispose() {
        this.myListIndex.clear();
        this.myTreeIndex.clear();
    }

    private static enum DisplayMode {
        LIST("Class List View"),
        TREE("Package Tree View");

        private String myName;

        private DisplayMode(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }

    private class TreeIndex
    implements SelectionModel.SelectionListener {
        private int myHeapId = -1;

        private TreeIndex() {
        }

        @Override
        public void onHeapChanged(Heap heap) {
            if (ClassesTreeView.this.myDisplayMode == DisplayMode.TREE) {
                assert (ClassesTreeView.this.myListIndex.myHeapId == heap.getId());
                this.buildTree(heap.getId());
            }
        }

        @Override
        public void onClassObjChanged(ClassObj classObj) {
        }

        @Override
        public void onInstanceChanged(Instance instance) {
        }

        private void buildTree(int heapId) {
            if (this.myHeapId != heapId) {
                this.myHeapId = heapId;
                ClassesTreeView.this.myRoot.clear();
                for (HeapClassObjNode heapClassObjNode : ((ClassesTreeView)ClassesTreeView.this).myListIndex.myClasses) {
                    ClassesTreeView.this.myRoot.classifyClassObj(heapClassObjNode);
                }
                ClassesTreeView.this.myRoot.update(ClassesTreeView.this.mySelectedHeapId);
            }
            ClassesTreeView.this.myRoot.buildTree();
        }

        private void clear() {
            ClassesTreeView.this.myRoot.clear();
        }
    }

    private static class ListIndex
    implements SelectionModel.SelectionListener {
        ArrayList<HeapClassObjNode> myClasses = new ArrayList();
        private int myHeapId = -1;

        private ListIndex() {
        }

        @Override
        public void onHeapChanged(Heap heap) {
            if (this.myHeapId != heap.getId()) {
                this.myHeapId = heap.getId();
                this.myClasses.clear();
                HashSet entriesSet = new HashSet(heap.getClasses().size() + heap.getInstancesCount());
                for (ClassObj classObj : heap.getClasses()) {
                    entriesSet.add((Object)classObj);
                }
                for (Instance instance : heap.getInstances()) {
                    entriesSet.add((Object)instance.getClassObj());
                }
                for (ClassObj classObj : entriesSet) {
                    this.myClasses.add(new HeapClassObjNode(classObj, this.myHeapId));
                }
            }
        }

        @Override
        public void onClassObjChanged(ClassObj classObj) {
        }

        @Override
        public void onInstanceChanged(Instance instance) {
        }

        private void buildList(HeapNode root) {
            root.removeAllChildren();
            for (HeapClassObjNode heapClassObjNode : this.myClasses) {
                heapClassObjNode.removeFromParent();
                root.add(heapClassObjNode);
            }
        }

        private void clear() {
            this.myClasses.clear();
        }
    }
}

