/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.hprof.HprofView;
import com.android.tools.idea.editors.hprof.views.HprofAnalysisContentsDelegate;
import com.android.tools.idea.profiling.view.CaptureEditor;
import com.android.tools.idea.profiling.view.CapturePanel;
import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.analyzer.CaptureGroup;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.captures.MemoryMappedFileBuffer;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.memoryanalyzer.DuplicatedStringsAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.LeakedActivityAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzer;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.JComponent;

public class HprofEditor
extends CaptureEditor {
    private static final Logger LOG = Logger.getInstance(HprofEditor.class);
    private HprofView myView;
    private Snapshot mySnapshot;
    private boolean myIsValid = true;

    public HprofEditor(final Project project, final VirtualFile file) {
        AnalyzerTask[] tasks = new AnalyzerTask[]{new LeakedActivityAnalyzerTask(), new DuplicatedStringsAnalyzerTask()};
        this.myPanel = new CapturePanel(project, this, tasks, true);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File hprofFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                InlineProgressIndicator indicator = HprofEditor.this.myPanel.getProgressIndicator();
                assert (indicator != null);
                try {
                    indicator.setFraction(0.0);
                    indicator.setText("Parsing hprof file...");
                    HprofEditor.this.mySnapshot = Snapshot.createSnapshot((DataBuffer)new MemoryMappedFileBuffer(hprofFile));
                    indicator.setFraction(0.5);
                    indicator.setText("Computing dominators...");
                    HprofEditor.this.mySnapshot.computeDominators();
                }
                catch (Throwable throwable) {
                    LOG.info(throwable);
                    final String errorMessage = "Unexpected error while processing hprof file: " + Throwables.getRootCause((Throwable)throwable).getMessage();
                    indicator.cancel();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)errorMessage, (String)HprofEditor.this.getName());
                        }
                    });
                }
                finally {
                    if (HprofEditor.this.mySnapshot != null) {
                        HprofEditor.this.myView = new HprofView(project, HprofEditor.this, HprofEditor.this.mySnapshot);
                        HprofAnalysisContentsDelegate delegate = new HprofAnalysisContentsDelegate(HprofEditor.this);
                        HprofEditor.this.myPanel.setEditorPanel(HprofEditor.this.myView.getComponent(), delegate);
                        Disposer.register((Disposable)HprofEditor.this, (Disposable)HprofEditor.this.myView);
                        Disposer.register((Disposable)HprofEditor.this, (Disposable)delegate);
                    }
                }
            }
        });
    }

    public HprofView getView() {
        return this.myView;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getName() {
        return "HprofView";
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public void setInvalid() {
        this.myIsValid = false;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.mySnapshot.dispose();
        this.mySnapshot = null;
        this.myPanel = null;
        this.myIsValid = false;
    }

    @Override
    public DesignerEditorPanelFacade getFacade() {
        return this.myPanel;
    }

    @Override
    public AnalysisReport performAnalysis(Set<? extends AnalyzerTask> tasks, Set<AnalysisReport.Listener> listeners) {
        assert (this.mySnapshot != null);
        CaptureGroup captureGroup = new CaptureGroup();
        captureGroup.addCapture((Capture)this.mySnapshot);
        MemoryAnalyzer memoryAnalyzer = new MemoryAnalyzer();
        assert (memoryAnalyzer.accept(captureGroup));
        return memoryAnalyzer.analyze(captureGroup, listeners, tasks, (Executor)EdtExecutor.INSTANCE, Executors.newSingleThreadExecutor());
    }
}

