/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.image.Format;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourceID;
import com.android.tools.idea.editors.gfxtrace.service.path.ThumbnailPath;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Array;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Pointer;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import java.awt.Dimension;
import java.io.IOException;

public final class ResourcePath
extends Path {
    private ResourceID myID;
    private AtomPath myAfter;
    private static final Entity ENTITY = new Entity("path", "Resource", "", "");

    @Override
    public StringBuilder stringPath(StringBuilder builder) {
        return this.myAfter.stringPath(builder).append(".Resource<").append((Object)this.myID).append(">");
    }

    @Override
    public Path getParent() {
        return this.myAfter;
    }

    public ThumbnailPath thumbnail(Dimension dimension, Format fmt) {
        return new ThumbnailPath().setObject(this).setDesiredMaxWidth(dimension.width).setDesiredMaxHeight(dimension.height).setDesiredFormat(fmt);
    }

    public ResourceID getID() {
        return this.myID;
    }

    public ResourcePath setID(ResourceID v) {
        this.myID = v;
        return this;
    }

    public AtomPath getAfter() {
        return this.myAfter;
    }

    public ResourcePath setAfter(AtomPath v) {
        this.myAfter = v;
        return this;
    }

    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static {
        ENTITY.setFields(new Field[]{new Field("ID", (Type)new Array("ResourceID", (Type)new Primitive("byte", 2), 20)), new Field("After", (Type)new Pointer((Type)new Struct(AtomPath.Klass.INSTANCE.entity())))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        public Entity entity() {
            return ENTITY;
        }

        public BinaryObject create() {
            return new ResourcePath();
        }

        public void encode(Encoder e, BinaryObject obj) throws IOException {
            ResourcePath o = (ResourcePath)obj;
            o.myID.write(e);
            e.object((BinaryObject)o.myAfter);
        }

        public void decode(Decoder d, BinaryObject obj) throws IOException {
            ResourcePath o = (ResourcePath)obj;
            o.myID = new ResourceID(d);
            o.myAfter = (AtomPath)d.object();
        }
    }
}

