/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import com.android.tools.idea.editors.gfxtrace.renderers.RenderUtils;
import com.android.tools.idea.editors.gfxtrace.widgets.CellWidget;
import com.android.tools.idea.editors.gfxtrace.widgets.ImageCellList;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadingIndicator;
import com.intellij.icons.AllIcons;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;

public class ImageCellRenderer<T extends ImageCellList.Data>
extends CellRenderer<T> {
    public static final int BORDER_SIZE = JBUI.scale((int)5);
    private static final int INNER_BORDER_SIZE = JBUI.scale((int)2);
    private static final int CORNER_RADIUS = JBUI.scale((int)4);
    private static final int MIN_HEIGHT = JBUI.scale((int)30);
    private static final Dimension INITIAL_SIZE = new Dimension(JBUI.scale((int)192) + BORDER_SIZE, JBUI.scale((int)108) + BORDER_SIZE);
    private static final Border DEFAULT_BORDER = new RoundedLineBorder(UIUtil.getBoundsColor(), BORDER_SIZE, INNER_BORDER_SIZE);
    private static final Border SELECTED_BORDER = new RoundedLineBorder(UIUtil.getListSelectionBackground(), BORDER_SIZE, BORDER_SIZE);
    private static final ImageCellList.Data NULL_CELL = new ImageCellList.Data(null){
        {
            this.loadingState = CellWidget.Data.LoadingState.LOADED;
        }
    };
    private final ImageComponent myCellComponent = new ImageComponent(Layout.CENTERED_WITH_OVERLAY, this.getInitialCellSize());
    private final Dimension myLargestKnownIconDimension = new Dimension(0, 0);
    private final Dimension myMaxSize;

    public ImageCellRenderer(CellRenderer.CellLoader<T> loader, Dimension maxSize) {
        super(loader);
        this.myMaxSize = maxSize;
    }

    @Override
    protected T createNullCell() {
        return (T)NULL_CELL;
    }

    @Override
    protected Component getRendererComponent(JList list, T cell) {
        this.myCellComponent.setCell((ImageCellList.Data)cell);
        if (((CellWidget.Data)cell).isLoading()) {
            LoadingIndicator.scheduleForRedraw(this.getRepaintable(list));
        }
        return this.myCellComponent;
    }

    public void setMinimumIconSize(Dimension dimension) {
        this.myLargestKnownIconDimension.width = Math.max(this.myLargestKnownIconDimension.width, dimension.width);
        this.myLargestKnownIconDimension.height = Math.max(this.myLargestKnownIconDimension.height, dimension.height);
        this.myCellComponent.setImageSize(this.myLargestKnownIconDimension);
    }

    @Override
    public Dimension getInitialCellSize() {
        return INITIAL_SIZE;
    }

    public void setLayout(Layout layout) {
        this.myCellComponent.setLayout(layout);
    }

    @Override
    protected void onCellLoaded(JList list, T cell) {
        boolean updated = false;
        if (this.myLargestKnownIconDimension.width < Math.min(this.myMaxSize.width, ((ImageCellList.Data)cell).icon.getIconWidth())) {
            updated = true;
            this.myLargestKnownIconDimension.width = Math.min(this.myMaxSize.width, ((ImageCellList.Data)cell).icon.getIconWidth());
        }
        if (this.myLargestKnownIconDimension.height < Math.min(this.myMaxSize.height, ((ImageCellList.Data)cell).icon.getIconHeight())) {
            updated = true;
            this.myLargestKnownIconDimension.height = Math.min(this.myMaxSize.height, ((ImageCellList.Data)cell).icon.getIconHeight());
        }
        if (updated) {
            list.setFixedCellWidth(2 * BORDER_SIZE + this.myLargestKnownIconDimension.width);
            list.setFixedCellHeight(2 * BORDER_SIZE + this.myLargestKnownIconDimension.height);
            this.myCellComponent.setImageSize(this.myLargestKnownIconDimension);
        }
    }

    public static enum Layout {
        CENTERED_WITH_OVERLAY,
        LEFT_TO_RIGHT;

    }

    private static class ImageComponent
    extends JComponent {
        private Layout myLayout;
        private Dimension myImageSize;
        private ImageCellList.Data myCell;

        public ImageComponent(Layout layout, Dimension imageSize) {
            this.myLayout = layout;
            this.myImageSize = imageSize;
        }

        public void setLayout(Layout layout) {
            this.myLayout = layout;
        }

        public void setImageSize(Dimension imageSize) {
            this.myImageSize = imageSize;
        }

        public void setCell(ImageCellList.Data cell) {
            this.myCell = cell;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.myImageSize.width + 2 * BORDER_SIZE, this.myImageSize.height + 2 * BORDER_SIZE);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int imageHeight;
            int imageWidth;
            if (this.myCell == NULL_CELL) {
                return;
            }
            if (this.getHeight() < MIN_HEIGHT) {
                graphics.setColor(UIUtil.getListBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.myCell.label != null) {
                    this.paintLabel(graphics, BORDER_SIZE);
                }
                return;
            }
            int w = this.getWidth() - 2 * BORDER_SIZE;
            int h = this.getHeight() - 2 * BORDER_SIZE;
            graphics.setColor(this.myCell.hasFailed() ? UIUtil.getLabelDisabledForeground() : UIUtil.getListBackground());
            graphics.fillRect(BORDER_SIZE, BORDER_SIZE, w, h);
            if (this.myLayout == Layout.CENTERED_WITH_OVERLAY) {
                imageWidth = w;
                imageHeight = h;
            } else {
                imageWidth = this.myImageSize.width;
                imageHeight = this.myImageSize.height;
            }
            if (this.myCell.isLoaded()) {
                if (this.myLayout == Layout.CENTERED_WITH_OVERLAY) {
                    RenderUtils.drawImage(this, graphics, this.myCell.icon.getImage(), BORDER_SIZE, BORDER_SIZE, imageWidth, imageHeight);
                } else {
                    RenderUtils.drawCroppedImage(this, graphics, this.myCell.icon.getImage(), BORDER_SIZE, BORDER_SIZE, imageWidth, imageHeight);
                }
            } else if (this.myCell.hasFailed()) {
                RenderUtils.drawIcon(this, graphics, AllIcons.General.Error, BORDER_SIZE, BORDER_SIZE, imageWidth, imageHeight);
            } else {
                LoadingIndicator.paint(this, graphics, BORDER_SIZE, BORDER_SIZE, imageWidth, imageHeight);
            }
            if (this.myCell.isSelected) {
                SELECTED_BORDER.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
            } else {
                int d = BORDER_SIZE - INNER_BORDER_SIZE;
                DEFAULT_BORDER.paintBorder(this, graphics, d, d, this.getWidth() - 2 * d, this.getHeight() - 2 * d);
            }
            if (this.myCell.label != null) {
                this.paintLabel(graphics, this.myImageSize.width + 2 * BORDER_SIZE);
            }
        }

        protected void paintLabel(Graphics g, int offset) {
            int OFFSET = 7;
            int PADDING = 2;
            FontMetrics metrics = g.getFontMetrics();
            int fontHeight = metrics.getHeight();
            int frameStringWidth = metrics.stringWidth(this.myCell.label);
            if (this.myLayout == Layout.CENTERED_WITH_OVERLAY) {
                g.setColor(UIUtil.getDecoratedRowColor());
                g.fillRoundRect(7, 7, frameStringWidth + 4 + 1, fontHeight + 4 + 1, CORNER_RADIUS, CORNER_RADIUS);
                g.setColor(this.getForeground());
                g.drawString(this.myCell.label, 10, 9 + fontHeight - metrics.getDescent());
            } else {
                g.setColor(this.getForeground());
                g.drawString(this.myCell.label, 2 + offset, (this.getHeight() + fontHeight) / 2 - metrics.getDescent());
            }
        }
    }
}

