/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.TreeController;
import com.android.tools.idea.editors.gfxtrace.renderers.RenderUtils;
import com.android.tools.idea.editors.gfxtrace.renderers.TreeRenderer;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.WireframeMode;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomGroup;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Observation;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.memory.PoolID;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadingIndicator;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintables;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.android.tools.rpclib.binary.BinaryObject;
import com.google.common.base.Objects;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AtomController
extends TreeController {
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    private final PathStore<AtomsPath> myAtomsPath = new PathStore();
    private final PathStore<DevicePath> myRenderDevice = new PathStore();
    private RegexFilterComponent mySearchField = new RegexFilterComponent(AtomController.class.getName(), 10, false);

    public static JComponent createUI(GfxTraceEditor editor) {
        return new AtomController((GfxTraceEditor)editor).myPanel;
    }

    private AtomController(GfxTraceEditor editor) {
        super(editor, "Loading capture...");
        this.myPanel.add((Component)((Object)this.mySearchField), "North");
        this.myPanel.setBorder(BorderFactory.createTitledBorder(this.myScrollPane.getBorder(), "GPU Commands"));
        this.myScrollPane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.myTree.setLargeModel(true);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (AtomController.this.myAtomsPath.getPath() == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)AtomController.this.myTree.getLastSelectedPathComponent();
                if (node == null || node.getUserObject() == null) {
                    return;
                }
                Object object = node.getUserObject();
                if (object instanceof Group) {
                    AtomController.this.myEditor.activatePath(((AtomsPath)AtomController.this.myAtomsPath.getPath()).index(((Group)object).group.getRange().getLast()), AtomController.this);
                } else if (object instanceof Node) {
                    AtomController.this.myEditor.activatePath(((AtomsPath)AtomController.this.myAtomsPath.getPath()).index(((Node)object).index), AtomController.this);
                } else if (object instanceof Memory) {
                    Memory memory = (Memory)object;
                    AtomController.this.myEditor.activatePath(((AtomsPath)AtomController.this.myAtomsPath.getPath()).index(memory.index).memoryAfter(PoolID.applicationPool(), memory.observation.getRange()), AtomController.this);
                }
            }
        });
        this.mySearchField.getTextEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    AtomController.this.findNextNode(AtomController.this.mySearchField.getPattern());
                }
            }
        });
        MouseAdapter mouseHandler = new MouseAdapter(){
            private static final int PREVIEW_HOVER_DELAY_MS = 500;
            private final ScheduledExecutorService scheduler = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"PreviewHover");
            private Group lastHoverGroup;
            private Future<?> lastScheduledFuture = Futures.immediateFuture(null);
            private Balloon lastShownBalloon;

            @Override
            public void mouseEntered(MouseEvent event) {
                this.updateHoveringGroupFor(event.getX(), event.getY());
            }

            @Override
            public void mouseExited(MouseEvent event) {
                this.setHoveringGroup(null, 0, 0);
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                this.updateHoveringGroupFor(event.getX(), event.getY());
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                this.setHoveringGroup(null, 0, 0);
                JBScrollPane ancestor = (JBScrollPane)SwingUtilities.getAncestorOfClass(JBScrollPane.class, (Component)AtomController.this.myTree);
                if (ancestor != null) {
                    MouseWheelEvent converted = (MouseWheelEvent)SwingUtilities.convertMouseEvent((Component)AtomController.this.myTree, event, (Component)ancestor);
                    for (MouseWheelListener listener : ancestor.getMouseWheelListeners()) {
                        listener.mouseWheelMoved(converted);
                    }
                }
                Point location = new Point(MouseInfo.getPointerInfo().getLocation());
                SwingUtilities.convertPointFromScreen(location, (Component)AtomController.this.myTree);
                this.updateHoveringGroupFor(location.x, location.y);
            }

            private void updateHoveringGroupFor(int mouseX, int mouseY) {
                Group group;
                Object userObject;
                TreePath path = AtomController.this.myTree.getClosestPathForLocation(mouseX, mouseY);
                if (path != null && (userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof Group && AtomController.shouldShowPreview(group = (Group)userObject)) {
                    Rectangle bounds = AtomController.this.myTree.getPathBounds(path);
                    int x = mouseX - bounds.x;
                    int y = mouseY - bounds.y;
                    if (x >= 0 && y >= 0 && x < Group.THUMBNAIL_SIZE && y < Group.THUMBNAIL_SIZE) {
                        this.setHoveringGroup(group, bounds.x + Group.THUMBNAIL_SIZE, bounds.y + Group.THUMBNAIL_SIZE / 2);
                        return;
                    }
                }
                this.setHoveringGroup(null, 0, 0);
            }

            private synchronized void setHoveringGroup(final Group group, final int x, final int y) {
                if (group != this.lastHoverGroup) {
                    this.lastScheduledFuture.cancel(true);
                    this.lastHoverGroup = group;
                    if (group != null) {
                        this.lastScheduledFuture = this.scheduler.schedule(new Runnable(){

                            @Override
                            public void run() {
                                this.hover(group, x, y);
                            }
                        }, 500L, TimeUnit.MILLISECONDS);
                    }
                }
                if (group == null && this.lastShownBalloon != null) {
                    this.lastShownBalloon.hide();
                    this.lastShownBalloon = null;
                }
            }

            private void hover(final Group group, final int x, final int y) {
                final 3 lock = this;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = lock;
                        synchronized (object) {
                            if (group == lastHoverGroup) {
                                if (lastShownBalloon != null) {
                                    lastShownBalloon.hide();
                                }
                                DevicePath device = (DevicePath)AtomController.this.myRenderDevice.getPath();
                                AtomsPath atoms = (AtomsPath)AtomController.this.myAtomsPath.getPath();
                                if (device != null && atoms != null) {
                                    lastShownBalloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new PreviewPanel(group.getThumbnail(AtomController.this.myEditor.getClient(), device, atoms))).setAnimationCycle(100).createBalloon();
                                    lastShownBalloon.show(new RelativePoint((Component)AtomController.this.myTree, new Point(x, y)), Balloon.Position.atRight);
                                }
                            }
                        }
                    }
                });
            }

            class PreviewPanel
            extends JComponent {
                private Image image;

                public PreviewPanel(final ListenableFuture<FetchedImage> imageFuture) {
                    if (imageFuture.isDone()) {
                        this.image = ((FetchedImage)Futures.getUnchecked(imageFuture)).icon.getImage();
                    } else {
                        imageFuture.addListener(new Runnable(){

                            @Override
                            public void run() {
                                PreviewPanel.this.image = ((FetchedImage)Futures.getUnchecked((Future)imageFuture)).icon.getImage();
                                Balloon parent = lastShownBalloon;
                                if (parent != null) {
                                    parent.revalidate();
                                }
                            }
                        }, (Executor)EdtExecutor.INSTANCE);
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    return this.image == null ? new Dimension(Group.PREVIEW_SIZE, Group.PREVIEW_SIZE) : new Dimension(this.image.getWidth(this), this.image.getHeight(this));
                }

                @Override
                protected void paintComponent(Graphics g) {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.image == null) {
                        LoadingIndicator.paint(this, g, 0, 0, this.getWidth(), this.getHeight());
                        LoadingIndicator.scheduleForRedraw(Repaintables.forComponent(this));
                    } else {
                        RenderUtils.drawImage(this, g, this.image, 0, 0, this.getWidth(), this.getHeight());
                    }
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)mouseHandler);
        this.myTree.addMouseMotionListener((MouseMotionListener)mouseHandler);
        this.myTree.addMouseWheelListener((MouseWheelListener)mouseHandler);
    }

    @Override
    protected TreeCellRenderer getRenderer() {
        return new TreeRenderer(){

            @Override
            public void customizeCellRenderer(final JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Group group;
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                DevicePath device = (DevicePath)AtomController.this.myRenderDevice.getPath();
                AtomsPath atoms = (AtomsPath)AtomController.this.myAtomsPath.getPath();
                if (userObject instanceof Group && device != null && atoms != null && AtomController.shouldShowPreview(group = (Group)userObject)) {
                    FetchedImage image;
                    ListenableFuture<FetchedImage> iconFuture = group.getThumbnail(AtomController.this.myEditor.getClient(), device, atoms);
                    if (iconFuture.isDone()) {
                        image = (FetchedImage)Futures.getUnchecked(iconFuture);
                    } else {
                        image = null;
                        iconFuture.addListener(new Runnable(){

                            @Override
                            public void run() {
                                tree.repaint();
                            }
                        }, (Executor)MoreExecutors.sameThreadExecutor());
                    }
                    this.setIcon(new Icon(){

                        @Override
                        public void paintIcon(Component component, Graphics g, int x, int y) {
                            if (image == null) {
                                LoadingIndicator.paint(tree, g, x, y, Group.THUMBNAIL_SIZE, Group.THUMBNAIL_SIZE);
                                LoadingIndicator.scheduleForRedraw(Repaintables.forComponent(tree));
                            } else {
                                ImageIcon icon = image.icon;
                                RenderUtils.drawImage(tree, g, icon.getImage(), x, y, Group.THUMBNAIL_SIZE, Group.THUMBNAIL_SIZE);
                            }
                        }

                        @Override
                        public int getIconWidth() {
                            return Group.THUMBNAIL_SIZE;
                        }

                        @Override
                        public int getIconHeight() {
                            return Group.THUMBNAIL_SIZE;
                        }
                    });
                }
            }
        };
    }

    private void findNextNode(Pattern pattern) {
        DefaultMutableTreeNode change;
        DefaultMutableTreeNode start = (DefaultMutableTreeNode)this.myTree.getLastSelectedPathComponent();
        if (start == null) {
            start = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        }
        if ((change = this.findMatchingChild(start, pattern)) == null) {
            for (DefaultMutableTreeNode node = start; change == null && node != null; node = (DefaultMutableTreeNode)node.getParent()) {
                change = this.findMatchingSibling(node, pattern);
            }
        }
        if (change == null && start != this.myTree.getModel().getRoot()) {
            change = this.findMatchingChild((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), pattern);
        }
        if (change != null) {
            TreePath path = new TreePath(change.getPath());
            this.myTree.setSelectionPath(path);
            this.myTree.scrollPathToVisible(path);
        }
    }

    private DefaultMutableTreeNode findMatchingChild(DefaultMutableTreeNode node, Pattern pattern) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (this.matches(child, pattern)) {
                return child;
            }
            DefaultMutableTreeNode result = this.findMatchingChild(child, pattern);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private DefaultMutableTreeNode findMatchingSibling(DefaultMutableTreeNode node, Pattern pattern) {
        for (DefaultMutableTreeNode sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (this.matches(sibling, pattern)) {
                return sibling;
            }
            DefaultMutableTreeNode result = this.findMatchingChild(sibling, pattern);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean matches(DefaultMutableTreeNode child, Pattern pattern) {
        Object node = child.getUserObject();
        if (node instanceof Node) {
            return pattern.matcher(((Node)node).atom.getName()).find();
        }
        return false;
    }

    private static boolean shouldShowPreview(Group group) {
        return group.lastLeaf.isEndOfFrame() || group.lastLeaf.isDrawCall();
    }

    private void selectDeepestVisibleNode(AtomPath atomPath) {
        if (atomPath == null) {
            return;
        }
        Object object = this.myTree.getModel().getRoot();
        assert (object instanceof DefaultMutableTreeNode);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        this.selectDeepestVisibleNode(root, new TreePath(root), atomPath.getIndex());
    }

    private void selectDeepestVisibleNode(DefaultMutableTreeNode node, TreePath path, long atomIndex) {
        if (node.isLeaf() || !this.myTree.isExpanded(path)) {
            this.myTree.setSelectionPath(path);
            this.myTree.scrollPathToVisible(path);
            return;
        }
        Enumeration<TreeNode> it = node.children();
        while (it.hasMoreElements()) {
            TreeNode obj = it.nextElement();
            assert (obj instanceof DefaultMutableTreeNode);
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)obj;
            Object object = child.getUserObject();
            boolean matches = false;
            if (object instanceof Group && ((Group)object).group.getRange().contains(atomIndex) || object instanceof Node && ((Node)object).index == atomIndex) {
                matches = true;
            }
            if (!matches) continue;
            this.selectDeepestVisibleNode(child, path.pathByAddingChild(child), atomIndex);
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        boolean updateAtoms = this.myAtomsPath.updateIfNotNull(CapturePath.atoms(event.findCapturePath()));
        if (this.myRenderDevice.updateIfNotNull(event.findDevicePath())) {
            this.myTree.repaint();
        }
        if (event.source != this) {
            this.selectDeepestVisibleNode(event.findAtomPath());
        }
        if (updateAtoms && this.myAtomsPath.getPath() != null) {
            this.myTree.getEmptyText().setText("");
            this.myLoadingPanel.startLoading();
            ListenableFuture<AtomList> atomF = this.myEditor.getClient().get(this.myAtomsPath.getPath());
            ListenableFuture<AtomGroup> hierarchyF = this.myEditor.getClient().get(this.myAtomsPath.getPath().getCapture().hierarchy());
            Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{atomF, hierarchyF}), (FutureCallback)new LoadingCallback<List<BinaryObject>>(LOG, this.myLoadingPanel){

                public void onSuccess(List<BinaryObject> all) {
                    AtomController.this.myLoadingPanel.stopLoading();
                    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Stream", true);
                    ((AtomGroup)all.get(1)).addChildren(root, (AtomList)all.get(0));
                    AtomController.this.setRoot(root);
                }
            }, (Executor)EdtExecutor.INSTANCE);
        }
    }

    public static class Memory {
        public final long index;
        public final Observation observation;
        public final boolean isRead;

        public Memory(long index, Observation observation, boolean isRead) {
            this.index = index;
            this.observation = observation;
            this.isRead = isRead;
        }
    }

    public static class Group {
        public static final int THUMBNAIL_SIZE = JBUI.scale((int)18);
        public static final int PREVIEW_SIZE = JBUI.scale((int)200);
        private static final RenderSettings THUMBNAIL_SETTINGS = new RenderSettings().setMaxWidth(PREVIEW_SIZE).setMaxHeight(PREVIEW_SIZE).setWireframeMode(WireframeMode.noWireframe());
        public final AtomGroup group;
        public final Atom lastLeaf;
        public final long indexOfLastLeaf;
        private ListenableFuture<FetchedImage> thumbnail;
        private DevicePath lastDevicePath;

        public Group(AtomGroup group, Atom lastLeaf, long indexOfLastLeaf) {
            this.group = group;
            this.lastLeaf = lastLeaf;
            this.indexOfLastLeaf = indexOfLastLeaf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListenableFuture<FetchedImage> getThumbnail(ServiceClient client, DevicePath devicePath, AtomsPath atomsPath) {
            Group group = this;
            synchronized (group) {
                if (this.thumbnail == null || !Objects.equal((Object)this.lastDevicePath, (Object)devicePath)) {
                    this.lastDevicePath = devicePath;
                    this.thumbnail = FetchedImage.load(client, client.getFramebufferColor(devicePath, new AtomPath().setAtoms(atomsPath).setIndex(this.indexOfLastLeaf), THUMBNAIL_SETTINGS));
                }
                return this.thumbnail;
            }
        }
    }

    public static class Node {
        public final long index;
        public final Atom atom;

        public Node(long index, Atom atom) {
            this.index = index;
            this.atom = atom;
        }
    }
}

