/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.chartlib.EventData;
import com.android.tools.idea.editors.gfxtrace.DeviceInfo;
import com.android.tools.idea.editors.gfxtrace.GfxTraceCaptureType;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;

public class GfxTracer {
    private static final Logger LOG = Logger.getInstance(GfxTracer.class);
    private static final String PRELOAD_LIB = "/data/local/tmp/libgapii.so";
    private static final int GAPII_PORT = 9286;
    private static final String GAPII_ABSTRACT_PORT = "gapii";
    private static final Pattern ENFORCING_PATTERN = Pattern.compile("^Enforcing$", 10);
    private static final Pattern PERMISSIVE_PATTERN = Pattern.compile("^Permissive$", 10);
    private final IDevice myDevice;
    final CaptureService myCaptureService;
    final CaptureHandle myCapture;
    final EventData myEvents;
    private volatile boolean myStopped = false;

    public static GfxTracer launch(Project project, IDevice device, final DeviceInfo.Package pkg, final DeviceInfo.Activity act, final Options options, EventData events) {
        final GfxTracer tracer = new GfxTracer(project, device, events);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                tracer.launchAndCapture(pkg, act, options);
            }
        });
        return tracer;
    }

    public static GfxTracer listen(Project project, IDevice device, final Options options, EventData events) {
        final GfxTracer tracer = new GfxTracer(project, device, events);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                tracer.capture(options);
            }
        });
        return tracer;
    }

    private GfxTracer(Project project, IDevice device, EventData events) {
        this.myCaptureService = CaptureService.getInstance(project);
        this.myDevice = device;
        this.myEvents = events;
        try {
            this.myCapture = this.myCaptureService.startCaptureFile(GfxTraceCaptureType.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchAndCapture(DeviceInfo.Package pkg, DeviceInfo.Activity act, Options options) {
        EventData.Event event = this.myEvents.start(System.currentTimeMillis(), 1);
        try {
            boolean wasEnforcing;
            String abi = pkg.myABI;
            if (abi == null) {
                abi = (String)this.myDevice.getAbis().get(0);
            }
            File myGapii = GapiPaths.findTraceLibrary(abi);
            String component = pkg.myName + "/" + act.myName;
            this.myDevice.root();
            String enforced = GfxTracer.captureAdbShell(this.myDevice, "getenforce");
            if (ENFORCING_PATTERN.matcher(enforced).find()) {
                wasEnforcing = true;
            } else if (PERMISSIVE_PATTERN.matcher(enforced).find()) {
                wasEnforcing = false;
            } else {
                LOG.error("Unexpected getenforce result'" + enforced + "'");
                wasEnforcing = true;
            }
            if (wasEnforcing) {
                GfxTracer.captureAdbShell(this.myDevice, "setenforce 0");
            }
            try {
                String propName = "wrap." + pkg.myName;
                if (propName.length() > 31) {
                    propName = propName.substring(0, 31);
                }
                while (propName.endsWith(".")) {
                    propName = propName.substring(0, propName.length() - 1);
                }
                this.myDevice.pushFile(myGapii.getAbsolutePath(), PRELOAD_LIB);
                GfxTracer.captureAdbShell(this.myDevice, "setprop " + propName + " LD_PRELOAD=" + PRELOAD_LIB);
                try {
                    GfxTracer.captureAdbShell(this.myDevice, "am start -S -W -n " + component);
                    event.stop(System.currentTimeMillis());
                    this.capture(options);
                }
                finally {
                    GfxTracer.captureAdbShell(this.myDevice, "setprop " + propName + " \"\"");
                }
            }
            finally {
                if (wasEnforcing) {
                    GfxTracer.captureAdbShell(this.myDevice, "setenforce 1");
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (event.to == -1L) {
                event.stop(System.currentTimeMillis());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void capture(Options options) {
        try {
            this.captureFromDevice(options);
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GfxTracer.this.myCaptureService.finalizeCaptureFileAsynchronous(GfxTracer.this.myCapture, new FutureCallback<Capture>(){

                            public void onSuccess(Capture capture) {
                                capture.getFile().refresh(true, false);
                                GfxTracer.this.myCaptureService.notifyCaptureReady(capture);
                            }

                            public void onFailure(Throwable t) {
                                LOG.error(t.getMessage());
                            }
                        }, (Executor)MoreExecutors.sameThreadExecutor());
                    }
                });
                throw throwable;
            }
        }
        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureFromDevice(Options options) throws AdbCommandRejectedException, IOException, TimeoutException, InterruptedException {
        try {
            this.myDevice.createForward(9286, GAPII_ABSTRACT_PORT, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
            this.captureFromSocket("localhost", 9286, options);
        }
        finally {
            this.myDevice.removeForward(9286, GAPII_ABSTRACT_PORT, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureFromSocket(String host, int port, Options options) throws IOException, InterruptedException {
        Socket socket = null;
        EventData.Event event = null;
        long total = 0L;
        byte[] buffer = new byte[4096];
        try {
            int len = 0;
            while (!this.myStopped) {
                if (socket == null) {
                    socket = new Socket(host, port);
                    socket.setSoTimeout(500);
                    GfxTracer.sendHeader(socket, options);
                }
                if ((len = GfxTracer.copyBlock(socket, this.myCapture, buffer)) > 0) {
                    if (event == null) {
                        event = this.myEvents.start(System.currentTimeMillis(), 2);
                    }
                    total += (long)len;
                    continue;
                }
                if (len >= 0) continue;
                socket.close();
                socket = null;
                if (total == 0L) {
                    Thread.sleep(500L);
                    continue;
                }
                this.myStopped = true;
            }
        }
        finally {
            if (event != null) {
                event.stop(System.currentTimeMillis());
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    private static void sendHeader(Socket socket, Options options) throws IOException {
        OutputStream out = socket.getOutputStream();
        byte[] b = new byte[]{115, 112, 121, 48, 2, 0, 0, 0, (byte)(options.myObserveFrameFrequency >> 0), (byte)(options.myObserveFrameFrequency >> 8), (byte)(options.myObserveFrameFrequency >> 16), (byte)(options.myObserveFrameFrequency >> 24), (byte)(options.myObserveDrawFrequency >> 0), (byte)(options.myObserveDrawFrequency >> 8), (byte)(options.myObserveDrawFrequency >> 16), (byte)(options.myObserveDrawFrequency >> 24)};
        out.write(b);
        out.flush();
    }

    public void stop() {
        this.myStopped = true;
    }

    private static int copyBlock(Socket socket, CaptureHandle capture, byte[] buffer) throws IOException {
        try {
            int len = socket.getInputStream().read(buffer);
            if (len > 0) {
                CaptureService.appendDataSynchronous(capture, buffer, 0, len);
            }
            return len;
        }
        catch (SocketTimeoutException e) {
            return 0;
        }
    }

    private static String captureAdbShell(IDevice device, String command) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        device.executeShellCommand(command, (IShellOutputReceiver)receiver);
        return receiver.getOutput();
    }

    public static class Options {
        public int myObserveFrameFrequency = 0;
        public int myObserveDrawFrequency = 0;
    }
}

