/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.nodes.AbstractTreeNode;
import com.android.tools.idea.editors.allocations.nodes.AllocNode;
import com.android.tools.idea.editors.allocations.nodes.ClassNode;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeNode;

public class PackageNode
extends AbstractTreeNode {
    private final String myName;
    private final Map<String, PackageNode> myChildrenMap;

    public PackageNode(String name) {
        this.myName = name;
        this.myChildrenMap = new HashMap<String, PackageNode>();
    }

    public void insert(String[] packages, AllocationInfo alloc, int depth) {
        if (depth < packages.length) {
            String name = packages[depth];
            PackageNode node = this.myChildrenMap.get(name);
            if (node == null) {
                node = depth == packages.length - 1 ? new ClassNode(name) : new PackageNode(name);
                this.myChildrenMap.put(name, node);
                this.addChild(node);
            }
            node.insert(packages, alloc, depth + 1);
        } else {
            this.addChild(new AllocNode(alloc));
        }
    }

    public String getName() {
        return this.myName;
    }

    public String getQualifiedName() {
        TreeNode parent = this.getParent();
        String pkg = parent instanceof PackageNode ? ((PackageNode)((Object)parent)).getQualifiedName() : "";
        return pkg.isEmpty() ? this.myName : pkg + "." + this.myName;
    }
}

