/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.ImageEditorPanel;
import com.android.draw9patch.ui.ImageViewer;
import com.intellij.AppTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.UIUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class NinePatchEditor
implements FileEditor,
ImageViewer.PatchUpdateListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.editors.NinePatchEditor");
    private static final String NAME = "9-Patch";
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final Project myProject;
    private VirtualFile myFile;
    private BufferedImage myBufferedImage;
    private ImageEditorPanel myImageEditorPanel;
    private boolean myDirtyFlag;

    public NinePatchEditor(Project project, VirtualFile file) {
        this.myProject = project;
        FileDocumentManagerAdapter saveListener = new FileDocumentManagerAdapter(){

            public void beforeAllDocumentsSaving() {
                NinePatchEditor.this.saveFile();
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)saveListener);
        this.myFile = file;
        try {
            this.myBufferedImage = this.loadImage(file);
            this.myImageEditorPanel = new ImageEditorPanel(null, this.myBufferedImage, this.myFile.getName());
            this.myImageEditorPanel.getViewer().addPatchUpdateListener((ImageViewer.PatchUpdateListener)this);
        }
        catch (IOException e) {
            LOG.error("Unexpected exception while reading 9-patch file", (Throwable)e);
        }
    }

    private BufferedImage loadImage(VirtualFile file) throws IOException {
        this.myBufferedImage = ImageIO.read(file.getInputStream());
        if (this.myBufferedImage == null) {
            throw new IOException("Unable to parse file: " + file.getCanonicalPath());
        }
        return GraphicsUtilities.toCompatibleImage((BufferedImage)this.myBufferedImage);
    }

    private void saveFile() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    NinePatchEditor.this.saveFileFromEDT();
                }
                catch (IOException e) {
                    LOG.error("Unexpected exception while saving 9-patch file", (Throwable)e);
                }
            }
        });
    }

    private void saveFileFromEDT() throws IOException {
        if (!this.myDirtyFlag) {
            return;
        }
        new WriteCommandAction.Simple(this.myProject, "Update N-patch", new PsiFile[]{PsiManager.getInstance((Project)this.myProject).findFile(this.myFile)}){

            protected void run() throws Throwable {
                ByteArrayOutputStream stream = new ByteArrayOutputStream((int)NinePatchEditor.this.myFile.getLength());
                ImageIO.write((RenderedImage)NinePatchEditor.this.myBufferedImage, "PNG", stream);
                NinePatchEditor.this.myFile.setBinaryContent(stream.toByteArray());
            }
        }.execute();
        this.myDirtyFlag = false;
    }

    public JComponent getComponent() {
        return this.myImageEditorPanel != null ? this.myImageEditorPanel : new JLabel("Unexpected error while loading 9-patch file. See Event Log for details.");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myImageEditorPanel;
    }

    public String getName() {
        return NAME;
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return this.myDirtyFlag;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.saveFile();
        if (this.myImageEditorPanel != null) {
            this.myImageEditorPanel.getViewer().removePatchUpdateListener((ImageViewer.PatchUpdateListener)this);
            this.myImageEditorPanel.dispose();
            this.myImageEditorPanel = null;
        }
    }

    public void patchesUpdated() {
        this.myDirtyFlag = true;
    }

    public <T> T getUserData(Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(Key<T> key, T value) {
        this.myUserDataHolder.putUserData(key, value);
    }
}

