/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import java.util.List;

public class AndroidFakeFileSystem
extends DummyFileSystem {
    public static final String PROTOCOL = "android-dummy";
    public static final VirtualFileSystem INSTANCE = new AndroidFakeFileSystem();
    public static final char SEPARATOR = '/';

    public String getProtocol() {
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(String path) {
        Module m;
        List components = Splitter.on((char)'/').splitToList((CharSequence)path);
        int size = components.size();
        if (size < 3) {
            return null;
        }
        String projectPath = Joiner.on((char)'/').join(components.subList(0, size - 2));
        String moduleName = (String)components.get(size - 2);
        String fileName = (String)components.get(size - 1);
        Project project = AndroidFakeFileSystem.findProject(projectPath);
        if (project == null) {
            return null;
        }
        if ("Theme Editor".equals(fileName)) {
            if (moduleName.isEmpty()) {
                return ThemeEditorVirtualFile.getThemeEditorFile(project);
            }
        } else if ("Translations Editor".equals(fileName) && (m = AndroidFakeFileSystem.findModule(project, moduleName)) != null) {
            return StringsVirtualFile.getStringsVirtualFile(m);
        }
        return null;
    }

    public static String constructPathForFile(String fileName, Module module) {
        return Joiner.on((char)'/').join((Object)module.getProject().getBasePath(), (Object)module.getName(), new Object[]{fileName});
    }

    public static String constructPathForFile(String fileName, Project project) {
        return Joiner.on((char)'/').join((Object)project.getBasePath(), (Object)"", new Object[]{fileName});
    }

    private static Module findModule(Project project, String name) {
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    private static Project findProject(String basePath) {
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!basePath.equals(p.getBasePath())) continue;
            return p;
        }
        return null;
    }
}

