/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.android.tools.idea.designer.Segment;
import com.android.tools.idea.designer.SegmentType;
import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import java.awt.Dimension;
import java.awt.Rectangle;

public class ResizeContext {
    private final EditableArea myArea;
    public final RadViewComponent node;
    public final RadViewComponent layout;
    public Rectangle bounds;
    public Dimension wrapSize;
    public Dimension fillSize;
    public Segment horizontalFillSegment;
    public Segment verticalFillSegment;
    public SegmentType horizontalEdgeType;
    public SegmentType verticalEdgeType;
    public boolean wrapWidth;
    public boolean wrapHeight;
    public boolean fillWidth;
    public boolean fillHeight;
    public Object clientData;
    public int modifierMask;
    public Object layoutView;

    ResizeContext(EditableArea area, RadViewComponent layout, Object layoutView, RadViewComponent node) {
        this.myArea = area;
        this.layout = layout;
        this.node = node;
        this.layoutView = layoutView;
        this.initializeSnapBounds();
    }

    protected void initializeSnapBounds() {
        this.wrapSize = this.node.calculateWrapSize(this.myArea);
        String width = this.node.getAttribute("layout_width", "http://schemas.android.com/apk/res/android");
        String height = this.node.getAttribute("layout_height", "http://schemas.android.com/apk/res/android");
        this.fillSize = new Dimension();
        Rectangle bounds = this.node.getBounds();
        Rectangle parentBounds = this.node.getParent().getBounds();
        this.fillSize.width = width != null && ResizeContext.isFill(width) ? bounds.width : parentBounds.x + parentBounds.width - bounds.x;
        this.fillSize.height = height != null && ResizeContext.isFill(height) ? bounds.height : parentBounds.y + parentBounds.height - bounds.y;
        if (this.fillSize.width == this.wrapSize.width) {
            this.fillSize.width += 5;
        }
        if (this.fillSize.height == this.wrapSize.height) {
            this.fillSize.height += 5;
        }
    }

    public static boolean isFill(String value) {
        return "fill_parent".equals(value) || "match_parent".equals(value);
    }

    public String getWidthAttribute() {
        if (this.wrapWidth) {
            return "wrap_content";
        }
        if (this.fillWidth) {
            return "match_parent";
        }
        return AndroidDesignerUtils.pxToDpWithUnits(this.myArea, this.bounds.width);
    }

    public String getHeightAttribute() {
        if (this.wrapHeight) {
            return "wrap_content";
        }
        if (this.fillHeight) {
            return "match_parent";
        }
        return AndroidDesignerUtils.pxToDpWithUnits(this.myArea, this.bounds.height);
    }
}

