/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.designer.MarginType;
import com.android.tools.idea.designer.ResizeContext;
import com.android.tools.idea.designer.ResizeOperation;
import com.android.tools.idea.designer.Segment;
import com.android.tools.idea.designer.SegmentType;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.utils.XmlUtils;
import com.google.common.collect.Maps;
import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.xml.XmlTag;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinearLayoutResizeOperation
extends ResizeOperation {
    public LinearLayoutResizeOperation(OperationContext context) {
        super(context);
    }

    protected static boolean isVertical(RadViewComponent node) {
        XmlTag tag = node.getTag();
        return "vertical".equals(tag.getAttributeValue("orientation", "http://schemas.android.com/apk/res/android"));
    }

    protected void updateResizeContext(LinearResizeContext resizeContext, RadViewComponent node, RadViewComponent layout, Rectangle oldBounds, Rectangle newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        Map<XmlTag, Dimension> sizes;
        Dimension nodePreferredSize;
        float sum;
        resizeContext.reset();
        if (oldBounds.equals(newBounds)) {
            return;
        }
        boolean isVertical = LinearLayoutResizeOperation.isVertical(layout);
        if (!isVertical && verticalEdge != null) {
            if (resizeContext.wrapWidth || resizeContext.fillWidth) {
                resizeContext.clearWeight(node);
                return;
            }
            if (newBounds.width == oldBounds.width) {
                return;
            }
        }
        if (isVertical && horizontalEdge != null) {
            if (resizeContext.wrapHeight || resizeContext.fillHeight) {
                resizeContext.clearWeight(node);
                return;
            }
            if (newBounds.height == oldBounds.height) {
                return;
            }
        }
        if ((sum = LinearLayoutResizeOperation.getWeightSum(layout)) <= 0.0f) {
            sum = 1.0f;
            resizeContext.setWeightSum(sum);
        }
        if ((nodePreferredSize = (sizes = resizeContext.myUnweightedSizes).get(node.getTag())) != null && (horizontalEdge != null && newBounds.height < nodePreferredSize.height || verticalEdge != null && newBounds.width < nodePreferredSize.width)) {
            return;
        }
        Rectangle layoutBounds = layout.getBounds();
        int remaining = (isVertical ? layoutBounds.height : layoutBounds.width) - resizeContext.myTotalLength;
        Dimension nodeSize = sizes.get(node.getTag());
        if (nodeSize == null) {
            return;
        }
        if (remaining > 0) {
            int missing = 0;
            if (isVertical) {
                if (newBounds.height > nodeSize.height) {
                    missing = newBounds.height - nodeSize.height;
                } else if (newBounds.height > resizeContext.wrapSize.height) {
                    missing = newBounds.height - resizeContext.wrapSize.height;
                    remaining += nodeSize.height - resizeContext.wrapSize.height;
                    resizeContext.wrapHeight = true;
                }
            } else if (newBounds.width > nodeSize.width) {
                missing = newBounds.width - nodeSize.width;
            } else if (newBounds.width > resizeContext.wrapSize.width) {
                missing = newBounds.width - resizeContext.wrapSize.width;
                remaining += nodeSize.width - resizeContext.wrapSize.width;
                resizeContext.wrapWidth = true;
            }
            if (missing > 0) {
                float weight = (float)missing * sum / (float)remaining;
                resizeContext.setWeight(weight);
            }
        }
    }

    @Override
    public void onResizeUpdate(RadViewComponent parent, Rectangle newBounds, int modifierMask) {
        Rectangle parentBounds;
        this.myResizeContext.bounds = newBounds;
        this.myResizeContext.modifierMask = modifierMask;
        this.myResizeContext.wrapHeight = false;
        this.myResizeContext.wrapWidth = false;
        if (this.myResizeContext.wrapSize != null) {
            Dimension b = this.myResizeContext.wrapSize;
            int maxMatchDistance = 20;
            if (this.myResizeContext.horizontalEdgeType != null && Math.abs(newBounds.height - b.height) < maxMatchDistance) {
                this.myResizeContext.wrapHeight = true;
                if (this.myResizeContext.horizontalEdgeType == SegmentType.TOP) {
                    newBounds.y += newBounds.height - b.height;
                }
                newBounds.height = b.height;
            }
            if (this.myResizeContext.verticalEdgeType != null && Math.abs(newBounds.width - b.width) < maxMatchDistance) {
                this.myResizeContext.wrapWidth = true;
                if (this.myResizeContext.verticalEdgeType == SegmentType.LEFT) {
                    newBounds.x += newBounds.width - b.width;
                }
                newBounds.width = b.width;
            }
        }
        this.myResizeContext.horizontalFillSegment = null;
        this.myResizeContext.fillHeight = false;
        if (this.myResizeContext.horizontalEdgeType == SegmentType.BOTTOM && !this.myResizeContext.wrapHeight) {
            parentBounds = parent.getBounds();
            this.myResizeContext.horizontalFillSegment = new Segment(parentBounds.y + parentBounds.height, newBounds.x, newBounds.x + newBounds.width, null, null, SegmentType.BOTTOM, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.y + newBounds.height - (parentBounds.y + parentBounds.height)) < 20) {
                this.myResizeContext.fillHeight = true;
                newBounds.height = parentBounds.y + parentBounds.height - newBounds.y;
            }
        }
        this.myResizeContext.verticalFillSegment = null;
        this.myResizeContext.fillWidth = false;
        if (this.myResizeContext.verticalEdgeType == SegmentType.RIGHT && !this.myResizeContext.wrapWidth) {
            parentBounds = parent.getBounds();
            this.myResizeContext.verticalFillSegment = new Segment(parentBounds.x + parentBounds.width, newBounds.y, newBounds.y + newBounds.height, null, null, SegmentType.RIGHT, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.x + newBounds.width - (parentBounds.x + parentBounds.width)) < 20) {
                this.myResizeContext.fillWidth = true;
                newBounds.width = parentBounds.x + parentBounds.width - newBounds.x;
            }
        }
    }

    @Override
    protected void setNewSizeBounds(ResizeContext context, RadViewComponent node, RadViewComponent layout, Rectangle oldBounds, Rectangle newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        LinearResizeContext resizeContext = (LinearResizeContext)context;
        this.updateResizeContext(resizeContext, node, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
        if (resizeContext.myUseWeight) {
            boolean isVertical = LinearLayoutResizeOperation.isVertical(layout);
            if (isVertical && horizontalEdge != null || !isVertical && verticalEdge != null) {
                resizeContext.apply();
            }
            if (!isVertical && horizontalEdge != null && (newBounds.height != oldBounds.height || resizeContext.wrapHeight || resizeContext.fillHeight)) {
                node.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", resizeContext.getHeightAttribute());
            }
            if (isVertical && verticalEdge != null && (newBounds.width != oldBounds.width || resizeContext.wrapWidth || resizeContext.fillWidth)) {
                node.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", resizeContext.getWidthAttribute());
            }
        } else {
            node.setAttribute("layout_weight", "http://schemas.android.com/apk/res/android", null);
            super.setNewSizeBounds(resizeContext, node, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
        }
    }

    @Override
    protected String getResizeUpdateMessage(ResizeContext context, RadViewComponent child, RadViewComponent parent, Rectangle newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        LinearResizeContext resizeContext = (LinearResizeContext)context;
        this.updateResizeContext(resizeContext, child, parent, child.getBounds(), newBounds, horizontalEdge, verticalEdge);
        if (resizeContext.myUseWeight) {
            String height;
            String width;
            String weight = XmlUtils.formatFloatAttribute((double)resizeContext.myWeight);
            String dimension = String.format("weight %1$s", weight);
            if (LinearLayoutResizeOperation.isVertical(parent)) {
                width = resizeContext.getWidthAttribute();
                height = dimension;
            } else {
                width = dimension;
                height = resizeContext.getHeightAttribute();
            }
            if (horizontalEdge == null) {
                return width;
            }
            if (verticalEdge == null) {
                return height;
            }
            return String.format("%s \u00d7 %s", width, height);
        }
        return super.getResizeUpdateMessage(context, child, parent, newBounds, horizontalEdge, verticalEdge);
    }

    private static float getWeight(RadViewComponent linearLayoutChild) {
        String weight = linearLayoutChild.getTag().getAttributeValue("layout_weight", "http://schemas.android.com/apk/res/android");
        if (weight != null && weight.length() > 0) {
            try {
                return Float.parseFloat(weight);
            }
            catch (NumberFormatException nfe) {
                Logger.getInstance(LinearLayoutResizeOperation.class).warn(String.format("Invalid weight %1$s", weight), (Throwable)nfe);
            }
        }
        return 0.0f;
    }

    private static float getWeightSum(RadViewComponent linearLayout) {
        String weightSum = linearLayout.getTag().getAttributeValue("weightSum", "http://schemas.android.com/apk/res/android");
        if (weightSum != null) {
            try {
                return Float.parseFloat(weightSum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return LinearLayoutResizeOperation.getSumOfWeights(linearLayout);
    }

    private static float getSumOfWeights(RadViewComponent linearLayout) {
        float sum = 0.0f;
        for (RadComponent child : linearLayout.getChildren()) {
            sum += LinearLayoutResizeOperation.getWeight((RadViewComponent)child);
        }
        return sum;
    }

    @Override
    protected ResizeContext createResizeContext(RadViewComponent layout, Object layoutView, RadViewComponent node) {
        return new LinearResizeContext(this.myContext.getArea(), layout, layoutView, node);
    }

    private class LinearResizeContext
    extends ResizeContext {
        public boolean myUseWeight;
        private float myNewWeightSum;
        private float myWeight;
        public final Map<XmlTag, Dimension> myUnweightedSizes;
        public int myTotalLength;
        public List<RadViewComponent> myClearWeights;

        private LinearResizeContext(EditableArea area, RadViewComponent layout, Object layoutView, RadViewComponent node) {
            super(area, layout, layoutView, node);
            this.myUnweightedSizes = this.computeUnweightedSizes();
            if (this.myUnweightedSizes != null) {
                this.myTotalLength = 0;
                boolean isVertical = LinearLayoutResizeOperation.isVertical(layout);
                for (Map.Entry<XmlTag, Dimension> entry : this.myUnweightedSizes.entrySet()) {
                    Dimension preferredSize = entry.getValue();
                    if (isVertical) {
                        this.myTotalLength += preferredSize.height;
                        continue;
                    }
                    this.myTotalLength += preferredSize.width;
                }
            }
        }

        private Map<XmlTag, Dimension> computeUnweightedSizes() {
            HashMap unweightedSizes = Maps.newHashMap();
            RadComponent parent = LinearLayoutResizeOperation.this.myComponent.getParent();
            if (!(parent instanceof RadViewComponent)) {
                return null;
            }
            XmlTag parentTag = ((RadViewComponent)parent).getTag();
            if (parentTag != null) {
                RenderTask task = AndroidDesignerUtils.createRenderTask(LinearLayoutResizeOperation.this.myContext.getArea());
                if (task == null) {
                    return null;
                }
                Map<XmlTag, ViewInfo> map = task.measureChildren(parentTag, new RenderTask.AttributeFilter(){

                    @Override
                    public String getAttribute(XmlTag n, String namespace, String localName) {
                        if ("layout_weight".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                            return "";
                        }
                        return null;
                    }
                });
                if (map != null) {
                    for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                        ViewInfo viewInfo = entry.getValue();
                        viewInfo = RenderService.getSafeBounds(viewInfo);
                        Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                        unweightedSizes.put(entry.getKey(), size);
                    }
                }
            }
            return unweightedSizes;
        }

        void reset() {
            this.myNewWeightSum = -1.0f;
            this.myUseWeight = false;
            this.myClearWeights = null;
        }

        void setWeight(float weight) {
            this.myUseWeight = true;
            this.myWeight = weight;
        }

        void setWeightSum(float weightSum) {
            this.myNewWeightSum = weightSum;
        }

        void clearWeight(RadViewComponent n) {
            if (this.myClearWeights == null) {
                this.myClearWeights = new ArrayList<RadViewComponent>();
            }
            this.myClearWeights.add(n);
        }

        public void apply() {
            assert (this.myUseWeight);
            String value = this.myWeight > 0.0f ? XmlUtils.formatFloatAttribute((double)this.myWeight) : null;
            this.node.setAttribute("layout_weight", "http://schemas.android.com/apk/res/android", value);
            if (this.myClearWeights != null) {
                for (RadViewComponent n : this.myClearWeights) {
                    if (!(LinearLayoutResizeOperation.getWeight(n) > 0.0f)) continue;
                    n.setAttribute("layout_weight", "http://schemas.android.com/apk/res/android", null);
                }
            }
            if ((double)this.myNewWeightSum > 0.0) {
                this.layout.setAttribute("weightSum", "http://schemas.android.com/apk/res/android", XmlUtils.formatFloatAttribute((double)this.myNewWeightSum));
            }
        }
    }
}

