/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.inspections.ResourceTypeInspection;

public class AndroidResolveHelper {
    public static PsiAnnotation getAnnotationForLocal(PsiElement context, String name) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        PsiVariable variable = facade.getResolveHelper().resolveReferencedVariable(name, context);
        if (variable != null) {
            return AndroidResolveHelper.getAnnotationForVariable(variable, 0);
        }
        return null;
    }

    private static PsiAnnotation getAnnotationForVariable(PsiVariable variable, int depth) {
        PsiReferenceExpression reference;
        PsiAnnotation annotation;
        PsiMethodCallExpression callExpression;
        PsiElement resolved;
        PsiAnnotation annotation2;
        if (depth > 10) {
            return null;
        }
        if ((variable instanceof PsiParameter || variable instanceof PsiLocalVariable) && (annotation2 = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)variable)) != null) {
            return annotation2;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (initializer instanceof PsiMethodCallExpression ? (resolved = (callExpression = (PsiMethodCallExpression)initializer).getMethodExpression().resolve()) instanceof PsiMethod && (annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)((PsiMethod)resolved))) != null : initializer instanceof PsiReferenceExpression && ((resolved = (reference = (PsiReferenceExpression)initializer).resolve()) instanceof PsiField ? (annotation = AndroidResolveHelper.getAnnotationForField((PsiField)resolved)) != null : resolved instanceof PsiVariable && (annotation = AndroidResolveHelper.getAnnotationForVariable((PsiVariable)resolved, depth + 1)) != null))) {
            return annotation;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class, (boolean)true);
        if (method == null) {
            return null;
        }
        Collection assignments = PsiTreeUtil.findChildrenOfType((PsiElement)method, PsiAssignmentExpression.class);
        for (PsiAssignmentExpression assignment : assignments) {
            PsiReferenceExpression ref;
            PsiAnnotation annotation3;
            PsiMethodCallExpression callExpression2;
            PsiElement r;
            PsiExpression rhs;
            PsiReferenceExpression reference2;
            PsiElement resolved2;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression) || (resolved2 = (reference2 = (PsiReferenceExpression)lhs).resolve()) != variable || !((rhs = assignment.getRExpression()) instanceof PsiMethodCallExpression ? (r = (callExpression2 = (PsiMethodCallExpression)rhs).getMethodExpression().resolve()) instanceof PsiMethod && (annotation3 = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)((PsiMethod)r))) != null : rhs instanceof PsiReferenceExpression && ((r = (ref = (PsiReferenceExpression)rhs).resolve()) instanceof PsiField ? (annotation3 = AndroidResolveHelper.getAnnotationForField((PsiField)r)) != null : r instanceof PsiVariable && (annotation3 = AndroidResolveHelper.getAnnotationForVariable((PsiVariable)r, depth + 1)) != null))) continue;
            return annotation3;
        }
        return null;
    }

    public static PsiAnnotation getAnnotationForField(PsiElement context, String className, String fieldName) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(className, AndroidResolveHelper.getSearchScope(context));
        if (psiClass == null) {
            return null;
        }
        PsiField field = psiClass.findFieldByName(fieldName, true);
        if (field != null) {
            return AndroidResolveHelper.getAnnotationForField(field);
        }
        return null;
    }

    private static PsiAnnotation getAnnotationForField(PsiField field) {
        PsiMethod getter;
        PsiAnnotation annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)field);
        if (annotation == null && (getter = PropertyUtil.findGetterForField((PsiField)field)) != null) {
            return AndroidResolveHelper.getAnnotation((PsiModifierListOwner)getter);
        }
        return annotation;
    }

    private static GlobalSearchScope getSearchScope(PsiElement context) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module != null) {
            return module.getModuleWithDependenciesAndLibrariesScope(false);
        }
        return GlobalSearchScope.projectScope((Project)context.getProject());
    }

    private static PsiAnnotation getAnnotation(PsiModifierListOwner owner) {
        if (owner == null) {
            return null;
        }
        Project project = owner.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope searchScope = AndroidResolveHelper.getSearchScope((PsiElement)owner);
        for (PsiAnnotation a : ResourceTypeInspection.getAllAnnotations(owner)) {
            String qualifiedName = a.getQualifiedName();
            if (qualifiedName == null || qualifiedName.startsWith("java")) continue;
            if (qualifiedName.endsWith("Res") || qualifiedName.equals("android.support.annotation.ColorInt") || qualifiedName.equals("android.support.annotation.IntDef")) {
                return a;
            }
            PsiClass annotationClass = psiFacade.findClass(qualifiedName, searchScope);
            PsiAnnotation annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static IntDefResolution resolveIntDef(PsiAnnotation annotation) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiAnnotationMemberValue intValues = annotation.findAttributeValue("value");
        PsiAnnotationMemberValue[] allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
        HashMap valuesMap = Maps.newHashMap();
        for (PsiAnnotationMemberValue value : allowedValues) {
            Object v;
            if (!(value instanceof PsiReference)) {
                return IntDefResolution.createError();
            }
            PsiElement resolved = ((PsiReference)value).resolve();
            if (!(resolved instanceof PsiNamedElement)) {
                return IntDefResolution.createError();
            }
            Key key = Key.findKeyByName((String)"VALUE");
            Integer constantValue = null;
            if (key != null && (v = value.getUserData(key)) instanceof Integer) {
                constantValue = (Integer)v;
            }
            if (constantValue == null && resolved instanceof PsiField && (v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiField)resolved).getInitializer(), null, (boolean)false)) instanceof Integer) {
                constantValue = (Integer)v;
            }
            if (constantValue == null) {
                return IntDefResolution.createError();
            }
            valuesMap.put(constantValue, ((PsiNamedElement)resolved).getName());
        }
        PsiAnnotationMemberValue orValue = annotation.findAttributeValue("flag");
        boolean canBeOred = orValue instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue());
        return new IntDefResolution(canBeOred, valuesMap);
    }

    public static class IntDefResolution {
        public final Map<Integer, String> valuesMap;
        public final boolean canBeOred;

        public IntDefResolution(boolean canBeOred, Map<Integer, String> valuesMap) {
            this.canBeOred = canBeOred;
            this.valuesMap = valuesMap;
        }

        public static IntDefResolution createError() {
            return new IntDefResolution(false, null);
        }
    }

    public static class ResolveResult {
        public final String label;
        public final Icon icon;

        public ResolveResult(String label, Icon icon) {
            this.label = label;
            this.icon = icon;
        }
    }
}

