/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenrecord;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.tools.idea.ddms.screenrecord.ScreenRecorderOptionsDialog;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.File;
import java.util.Calendar;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;

public class ScreenRecorderAction {
    private static final String TITLE = "Screen Recorder";
    private static final String REMOTE_PATH = "/sdcard/ddmsrec.mp4";
    private static VirtualFile ourLastSavedFolder;
    private final Project myProject;
    private final IDevice myDevice;

    public ScreenRecorderAction(Project p, IDevice device) {
        this.myProject = p;
        this.myDevice = device;
    }

    public void performAction() {
        ScreenRecorderOptionsDialog dialog = new ScreenRecorderOptionsDialog(this.myProject);
        if (!dialog.showAndGet()) {
            return;
        }
        final ScreenRecorderOptions options = dialog.getOptions();
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ScreenRecorderAction.this.myDevice.startScreenRecorder(ScreenRecorderAction.REMOTE_PATH, options, (IShellOutputReceiver)receiver);
                }
                catch (Exception e) {
                    ScreenRecorderAction.showError(ScreenRecorderAction.this.myProject, "Unexpected error while launching screen recorder", e);
                    latch.countDown();
                }
            }
        });
        ScreenRecorderTask screenRecorderShellTask = new ScreenRecorderTask(this.myProject, this.myDevice, latch, receiver);
        screenRecorderShellTask.setCancelText("Stop Recording");
        screenRecorderShellTask.queue();
    }

    private static void showError(final Project project, final String message, final Throwable throwable) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String msg = message;
                if (throwable != null) {
                    msg = msg + (throwable.getLocalizedMessage() != null ? ": " + throwable.getLocalizedMessage() : "");
                }
                Messages.showErrorDialog((Project)project, (String)msg, (String)ScreenRecorderAction.TITLE);
            }
        });
    }

    private static class PullRecordingTask
    extends Task.Modal {
        private final String myLocalPath;
        private final IDevice myDevice;

        public PullRecordingTask(Project project, IDevice device, String localFilePath) {
            super(project, ScreenRecorderAction.TITLE, false);
            this.myDevice = device;
            this.myLocalPath = localFilePath;
        }

        public void run(ProgressIndicator indicator) {
            try {
                this.myDevice.pullFile(ScreenRecorderAction.REMOTE_PATH, this.myLocalPath);
            }
            catch (Exception e) {
                ScreenRecorderAction.showError(this.myProject, "Unexpected error while copying video recording from device", e);
            }
        }

        private void openSavedFile() {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.myLocalPath);
            if (file != null) {
                NativeFileType.openAssociatedApplication((VirtualFile)file);
            }
        }

        public void onSuccess() {
            assert (this.myProject != null);
            if (ShowFilePathAction.isSupported()) {
                int exitCode = Messages.showYesNoCancelDialog((Project)this.myProject, (String)("Video Recording saved as " + this.myLocalPath), (String)ScreenRecorderAction.TITLE, (String)"Open", (String)("Show in " + ShowFilePathAction.getFileManagerName()), (String)CommonBundle.getOkButtonText(), (Icon)Messages.getInformationIcon());
                if (exitCode == 0) {
                    this.openSavedFile();
                } else if (exitCode == 1) {
                    ShowFilePathAction.openFile((File)new File(this.myLocalPath));
                }
            } else if (Messages.showOkCancelDialog((Project)this.myProject, (String)("Video Recording saved as " + this.myLocalPath), (String)ScreenRecorderAction.TITLE, (String)"Open File", (String)CommonBundle.getOkButtonText(), (Icon)Messages.getInformationIcon()) == 0) {
                this.openSavedFile();
            }
        }
    }

    private static class ScreenRecorderTask
    extends Task.Modal {
        private final IDevice myDevice;
        private final CountDownLatch myCompletionLatch;
        private final CollectingOutputReceiver myReceiver;

        public ScreenRecorderTask(Project project, IDevice device, CountDownLatch completionLatch, CollectingOutputReceiver receiver) {
            super(project, ScreenRecorderAction.TITLE, true);
            this.myDevice = device;
            this.myCompletionLatch = completionLatch;
            this.myReceiver = receiver;
        }

        public void run(ProgressIndicator indicator) {
            int elapsedTime = 0;
            indicator.setIndeterminate(true);
            block2: while (true) {
                try {
                    while (!this.myCompletionLatch.await(1L, TimeUnit.SECONDS)) {
                        indicator.setText(String.format("Recording...%1$d %2$s elapsed", ++elapsedTime, StringUtil.pluralize((String)"second", (int)elapsedTime)));
                        if (!indicator.isCanceled()) continue;
                        this.myReceiver.cancel();
                        indicator.setText("Stopping...");
                        this.myCompletionLatch.await(1L, TimeUnit.SECONDS);
                        break block2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void onSuccess() {
            this.pullRecording();
        }

        public void onCancel() {
            this.pullRecording();
        }

        private void pullRecording() {
            VirtualFile baseDir;
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save As", "", new String[]{"mp4"});
            FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.myProject);
            VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir = ourLastSavedFolder != null ? ourLastSavedFolder : VfsUtil.getUserHomeDir(), ScreenRecorderTask.getDefaultFileName());
            if (fileWrapper == null) {
                return;
            }
            File f = fileWrapper.getFile();
            ourLastSavedFolder = VfsUtil.findFileByIoFile((File)f.getParentFile(), (boolean)false);
            new PullRecordingTask(this.myProject, this.myDevice, f.getAbsolutePath()).queue();
        }

        private static String getDefaultFileName() {
            Calendar now = Calendar.getInstance();
            return String.format("device-%tF-%tH%tM%tS", now, now, now, now);
        }
    }
}

