/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.ddms.screenshot.ScreenshotTask;
import com.android.tools.idea.ddms.screenshot.ScreenshotViewer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import icons.AndroidIcons;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.jetbrains.android.util.AndroidBundle;

public class ScreenshotAction
extends AbstractDeviceAction {
    private final Project myProject;

    public ScreenshotAction(Project p, DeviceContext context) {
        super(context, AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]), AndroidBundle.message("android.ddms.actions.screenshot.description", new Object[0]), AndroidIcons.Ddms.ScreenCapture);
        this.myProject = p;
    }

    @Override
    protected void performAction(final IDevice device) {
        final Project project = this.myProject;
        new ScreenshotTask(project, device){

            public void onSuccess() {
                String msg = this.getError();
                if (msg != null) {
                    Messages.showErrorDialog((Project)project, (String)msg, (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
                    return;
                }
                try {
                    File backingFile = FileUtil.createTempFile((String)"screenshot", (String)".png", (boolean)true);
                    ImageIO.write((RenderedImage)this.getScreenshot(), "png", backingFile);
                    final ScreenshotViewer viewer = new ScreenshotViewer(project, this.getScreenshot(), backingFile, device, device.getProperty("ro.product.model"));
                    viewer.showAndGetOk().doWhenDone((Consumer)new Consumer<Boolean>(){

                        public void consume(Boolean ok) {
                            if (ok.booleanValue()) {
                                File screenshot = viewer.getScreenshot();
                                VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(screenshot);
                                if (vf != null) {
                                    vf.refresh(false, false);
                                    FileEditorManager.getInstance((Project)project).openFile(vf, true);
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("android.ddms.screenshot.generic.error", e), (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
                }
            }
        }.queue();
    }
}

