/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.ddms.DeviceContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import javax.swing.Icon;

public abstract class AbstractClientToggleAction
extends ToggleAction {
    private final DeviceContext myDeviceContext;

    public AbstractClientToggleAction(DeviceContext context, String text, String description, Icon icon) {
        super(text, description, icon);
        this.myDeviceContext = context;
    }

    public final boolean isSelected(AnActionEvent e) {
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null || !c.isValid()) {
            return false;
        }
        return this.isSelected(c);
    }

    public final void setSelected(AnActionEvent e, boolean state) {
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null || !c.isValid()) {
            return;
        }
        this.setSelected(c);
    }

    public final void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null || !c.isValid()) {
            presentation.setEnabled(false);
            return;
        }
        String text = this.getActiveText(c);
        presentation.setText(text);
        presentation.setEnabled(true);
    }

    protected abstract boolean isSelected(Client var1);

    protected abstract void setSelected(Client var1);

    protected abstract String getActiveText(Client var1);
}

