/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.android.util.AndroidBundle;

public class DeviceRenderer {
    private DeviceRenderer() {
    }

    static void renderDeviceName(IDevice d, ColoredTextContainer component) {
        DeviceRenderer.renderDeviceName(d, component, null);
    }

    static void renderDeviceName(IDevice d, ColoredTextContainer component, AvdManager avdManager) {
        String name;
        component.setIcon(d.isEmulator() ? AndroidIcons.Ddms.Emulator2 : AndroidIcons.Ddms.RealDevice);
        if (d.isEmulator()) {
            AvdInfo info;
            String avdName = d.getAvdName();
            if (avdManager != null && (info = avdManager.getAvd(avdName, true)) != null) {
                avdName = (String)info.getProperties().get("avd.ini.displayname");
            }
            if (avdName == null) {
                avdName = "unknown";
            }
            name = String.format("%1$s %2$s ", AndroidBundle.message("android.emulator", new Object[0]), avdName);
        } else {
            name = String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(d, ""), DevicePropertyUtil.getModel(d, ""));
        }
        component.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        IDevice.DeviceState deviceState = d.getState();
        if (deviceState != IDevice.DeviceState.ONLINE) {
            String state = String.format("%1$s [%2$s] ", d.getSerialNumber(), d.getState());
            component.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (deviceState != IDevice.DeviceState.DISCONNECTED && deviceState != IDevice.DeviceState.OFFLINE) {
            component.append(DevicePropertyUtil.getBuild(d), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static class DeviceNameRenderer
    extends ColoredTableCellRenderer {
        private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
        private final DeviceNameRendererEx[] myRenderers = (DeviceNameRendererEx[])EP_NAME.getExtensions();
        private final AvdManager myAvdManager;

        public DeviceNameRenderer(AvdManager avdManager) {
            this.myAvdManager = avdManager;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (!(value instanceof IDevice)) {
                return;
            }
            IDevice device = (IDevice)value;
            for (DeviceNameRendererEx renderer : this.myRenderers) {
                if (!renderer.isApplicable(device)) continue;
                renderer.render(device, (ColoredTextContainer)this);
                return;
            }
            DeviceRenderer.renderDeviceName(device, (ColoredTextContainer)this, this.myAvdManager);
        }
    }

    public static class DeviceComboBoxRenderer
    extends ColoredListCellRenderer {
        private String myEmptyText;

        public DeviceComboBoxRenderer(String emptyText) {
            this.myEmptyText = emptyText;
        }

        public DeviceComboBoxRenderer() {
            this("[none]");
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value instanceof IDevice) {
                DeviceRenderer.renderDeviceName((IDevice)value, (ColoredTextContainer)this);
            } else if (value == null) {
                this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }
    }
}

