/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class FlatComboAction
extends AnAction
implements CustomComponentAction {
    private static final Icon ARROW_DOWN = AndroidIcons.ArrowDown;
    private static final Icon DISABLED_ARROW_ICON = IconLoader.getDisabledIcon((Icon)ARROW_DOWN);
    private DataContext myDataContext;

    protected FlatComboAction() {
    }

    protected boolean handleIconClicked() {
        return false;
    }

    public void actionPerformed(AnActionEvent e) {
    }

    public JComponent createCustomComponent(Presentation presentation) {
        return this.createComboBoxButton(presentation);
    }

    protected FlatComboButton createComboBoxButton(Presentation presentation) {
        return new FlatComboButton(presentation);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        this.myDataContext = e.getDataContext();
    }

    protected abstract DefaultActionGroup createPopupActionGroup(JComponent var1);

    protected int getMaxRows() {
        return 30;
    }

    protected int getMinHeight() {
        return 1;
    }

    protected int getMinWidth() {
        return 1;
    }

    protected class FlatComboButton
    extends JButton {
        private final Presentation myPresentation;
        private boolean myForcePressed = false;
        private PropertyChangeListener myButtonSynchronizer;
        private boolean myMouseInside = false;
        private JBPopup myPopup;

        public FlatComboButton(Presentation presentation) {
            this.myPresentation = presentation;
            this.setModel(new MyButtonModel());
            this.setHorizontalAlignment(2);
            this.setFocusable(false);
            Insets margins = this.getMargin();
            this.setMargin(new Insets(margins.top, 2, margins.bottom, 2));
            this.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)2, (int)0, (int)2));
            if (!UIUtil.isUnderGTKLookAndFeel()) {
                this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!FlatComboButton.this.myForcePressed) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

                            @Override
                            public void run() {
                                Icon icon = FlatComboButton.this.getIcon();
                                if (icon != null && FlatComboButton.this.isShowing()) {
                                    Point location = MouseInfo.getPointerInfo().getLocation();
                                    Point current = FlatComboButton.this.getLocationOnScreen();
                                    int x = location.x - current.x;
                                    if (x < icon.getIconWidth() + 3 && FlatComboAction.this.handleIconClicked()) {
                                        return;
                                    }
                                }
                                FlatComboButton.this.showPopup();
                            }
                        });
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    FlatComboButton.this.myMouseInside = true;
                    FlatComboButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FlatComboButton.this.myMouseInside = false;
                    FlatComboButton.this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        e.consume();
                        FlatComboButton.this.doClick();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    FlatComboButton.this.dispatchEventToPopup(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(new MouseEvent(e.getComponent(), 503, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    FlatComboButton.this.dispatchEventToPopup(e);
                }
            });
        }

        private void dispatchEventToPopup(MouseEvent e) {
            if (this.myPopup != null && this.myPopup.isVisible()) {
                MouseEvent event;
                Component component;
                JComponent content = this.myPopup.getContent();
                Rectangle rectangle = content.getBounds();
                Point location = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(location, content);
                Point eventPoint = e.getLocationOnScreen();
                rectangle.setLocation(location);
                if (rectangle.contains(eventPoint) && (component = SwingUtilities.getDeepestComponentAt(content, (event = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.myPopup.getContent())).getX(), event.getY())) != null) {
                    component.dispatchEvent(event);
                }
            }
        }

        public void showPopup() {
            this.myForcePressed = true;
            this.repaint();
            Runnable onDispose = new Runnable(){

                @Override
                public void run() {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FlatComboButton.this.myForcePressed = false;
                            FlatComboButton.this.myPopup = null;
                        }
                    });
                    FlatComboButton.this.repaint();
                }
            };
            this.myPopup = this.createPopup(onDispose);
            this.myPopup.show(new RelativePoint((Component)this, new Point(0, this.getHeight() - 1)));
        }

        @Override
        public String getToolTipText() {
            return this.myForcePressed ? null : super.getToolTipText();
        }

        protected JBPopup createPopup(Runnable onDispose) {
            DefaultActionGroup group = FlatComboAction.this.createPopupActionGroup(this);
            DataContext context = this.getDataContext();
            FlatComboAction.this.myDataContext = null;
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, onDispose, FlatComboAction.this.getMaxRows());
            popup.setMinimumSize(new Dimension(FlatComboAction.this.getMinWidth(), FlatComboAction.this.getMinHeight()));
            return popup;
        }

        protected DataContext getDataContext() {
            return FlatComboAction.this.myDataContext == null || PlatformDataKeys.CONTEXT_COMPONENT.getData(FlatComboAction.this.myDataContext) == null ? DataManager.getInstance().getDataContext((Component)this) : FlatComboAction.this.myDataContext;
        }

        @Override
        public void removeNotify() {
            if (this.myButtonSynchronizer != null) {
                this.myPresentation.removePropertyChangeListener(this.myButtonSynchronizer);
                this.myButtonSynchronizer = null;
            }
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.myButtonSynchronizer == null) {
                this.myButtonSynchronizer = new MyButtonSynchronizer();
                this.myPresentation.addPropertyChangeListener(this.myButtonSynchronizer);
            }
            this.initButton();
        }

        private void initButton() {
            this.setIcon(this.myPresentation.getIcon());
            this.setEnabled(this.myPresentation.isEnabled());
            this.setText(this.myPresentation.getText());
            this.updateTooltipText(this.myPresentation.getDescription());
            this.updateButtonSize();
        }

        private void updateTooltipText(String description) {
            String tooltip = KeymapUtil.createTooltipText((String)description, (AnAction)FlatComboAction.this);
            this.setToolTipText(!tooltip.isEmpty() ? tooltip : null);
        }

        @Override
        public Insets getInsets() {
            Insets insets = super.getInsets();
            return new Insets(insets.top, insets.left, insets.bottom, insets.right + ARROW_DOWN.getIconWidth());
        }

        @Override
        public Insets getInsets(Insets insets) {
            Insets result = super.getInsets(insets);
            result.right += ARROW_DOWN.getIconWidth();
            return result;
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            boolean isEmpty = this.getIcon() == null && StringUtil.isEmpty((String)this.getText());
            int width = isEmpty ? 10 + ARROW_DOWN.getIconWidth() : super.getPreferredSize().width;
            return new Dimension(width, JBUI.scale((int)24));
        }

        @Override
        public void paint(Graphics g) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
            boolean textEmpty = StringUtil.isEmpty((String)this.getText());
            boolean isEmpty = this.getIcon() == null && textEmpty;
            Dimension size = this.getSize();
            Graphics2D g2 = (Graphics2D)g;
            Color controlColor = this.getParent().getBackground();
            g2.setColor(controlColor);
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.getModel().isArmed() && this.getModel().isPressed()) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, controlColor, 0.0f, h, ColorUtil.shift((Color)controlColor, (double)0.8)));
            } else if (this.myMouseInside) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift((Color)controlColor, (double)1.1), 0.0f, h, ColorUtil.shift((Color)controlColor, (double)0.9)));
            }
            g2.fillRect(1, 1, w - 2, h - 2);
            GraphicsUtil.setupAntialiasing((Graphics)g2);
            if (this.myMouseInside) {
                if (!UIUtil.isUnderDarcula()) {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, UIUtil.getBorderColor().darker(), 0.0f, h, UIUtil.getBorderColor().darker().darker()));
                } else {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift((Color)controlColor, (double)1.4), 0.0f, h, ColorUtil.shift((Color)controlColor, (double)1.5)));
                }
                g2.drawRect(0, 0, w - 1, h - 1);
            }
            Icon icon = this.getIcon();
            int x = 2;
            if (icon != null) {
                icon.paintIcon(null, g, x, (size.height - icon.getIconHeight()) / 2 - 1);
                x += icon.getIconWidth() + 1;
            }
            if (!textEmpty) {
                Font font = this.getFont();
                g2.setFont(font);
                g2.setColor(UIManager.getColor("Panel.foreground"));
                g2.drawString(this.getText(), x, (size.height + font.getSize()) / 2 - 1);
            }
            Insets insets = super.getInsets();
            Icon icon2 = this.isEnabled() ? ARROW_DOWN : DISABLED_ARROW_ICON;
            int x2 = isEmpty ? (size.width - icon2.getIconWidth()) / 2 : size.width - icon2.getIconWidth() - insets.right - (textEmpty ? 1 : 4);
            icon2.paintIcon(null, g, x2, (size.height - icon2.getIconHeight()) / 2);
            g.setPaintMode();
        }

        protected void updateButtonSize() {
            this.invalidate();
            this.repaint();
        }

        private class MyButtonSynchronizer
        implements PropertyChangeListener {
            private MyButtonSynchronizer() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("text".equals(propertyName)) {
                    FlatComboButton.this.setText((String)evt.getNewValue());
                    FlatComboButton.this.updateButtonSize();
                } else if ("description".equals(propertyName)) {
                    FlatComboButton.this.updateTooltipText((String)evt.getNewValue());
                } else if ("icon".equals(propertyName)) {
                    FlatComboButton.this.setIcon((Icon)evt.getNewValue());
                    FlatComboButton.this.updateButtonSize();
                } else if ("enabled".equals(propertyName)) {
                    FlatComboButton.this.setEnabled((Boolean)evt.getNewValue());
                }
            }
        }

        protected class MyButtonModel
        extends DefaultButtonModel {
            protected MyButtonModel() {
            }

            @Override
            public boolean isPressed() {
                return FlatComboButton.this.myForcePressed || super.isPressed();
            }

            @Override
            public boolean isArmed() {
                return FlatComboButton.this.myForcePressed || super.isArmed();
            }
        }
    }
}

