/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationMenuAction;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.android.facet.AndroidFacet;

public class DeviceMenuAction
extends FlatComboAction {
    private static final boolean LIST_RECENT_DEVICES = false;
    private final RenderContext myRenderContext;
    private final boolean myClassicStyle;

    public DeviceMenuAction(RenderContext renderContext) {
        this(renderContext, !RenderService.NELE_ENABLED);
    }

    public DeviceMenuAction(RenderContext renderContext, boolean classicStyle) {
        this.myRenderContext = renderContext;
        this.myClassicStyle = classicStyle;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("The virtual device to render the layout with");
        if (classicStyle) {
            presentation.setIcon(AndroidIcons.Display);
        }
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Device device = configuration.getDevice();
            String label = DeviceMenuAction.getDeviceLabel(device, true);
            presentation.setText(label);
            if (!this.myClassicStyle) {
                presentation.setIcon(this.getDeviceClassIcon(device));
            }
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public static String getDeviceLabel(Device device, boolean brief) {
        if (device == null) {
            return "";
        }
        String name = device.getDisplayName();
        if (brief) {
            int end;
            int begin;
            int nexus = name.indexOf("Nexus");
            if (nexus != -1 && (begin = name.indexOf(40)) != -1 && (end = name.indexOf(41, ++begin)) != -1) {
                if (name.equals("Nexus 7 (2012)")) {
                    return "Nexus 7";
                }
                return name.substring(begin, end).trim();
            }
            String skipPrefix = "Android ";
            if (name.startsWith(skipPrefix)) {
                name = name.substring(skipPrefix.length());
            }
        }
        return name;
    }

    public Icon getDeviceClassIcon(Device device) {
        if (this.myClassicStyle) {
            FormFactor formFactor = device != null ? FormFactor.getFormFactor(device) : FormFactor.MOBILE;
            return formFactor.getIcon();
        }
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return AndroidIcons.NeleIcons.Wear;
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return AndroidIcons.NeleIcons.Tv;
            }
            if (DeviceArtPainter.isTablet(device)) {
                return AndroidIcons.NeleIcons.Tablet;
            }
        }
        return AndroidIcons.NeleIcons.Phone;
    }

    @Override
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return group;
        }
        Device current = configuration.getDevice();
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        List<Device> deviceList = configurationManager.getDevices();
        AndroidFacet facet = AndroidFacet.getInstance(configurationManager.getModule());
        if (facet == null) {
            return group;
        }
        AvdManager avdManager = facet.getAvdManagerSilently();
        if (avdManager != null) {
            boolean separatorNeeded = false;
            for (AvdInfo avd : avdManager.getValidAvds()) {
                Device device = configurationManager.createDeviceForAvd(avd);
                if (device == null) continue;
                String avdName = "AVD: " + avd.getName();
                boolean selected = current != null && (current.getDisplayName().equals(avdName) || current.getId().equals(avdName));
                Icon icon = this.getDeviceClassIcon(device);
                group.add((AnAction)new SetDeviceAction(this.myRenderContext, avdName, device, icon, selected));
                separatorNeeded = true;
            }
            if (separatorNeeded) {
                group.addSeparator();
            }
        }
        if (!deviceList.isEmpty()) {
            TreeMap manufacturers = new TreeMap();
            for (Device device : deviceList) {
                List<Device> devices;
                if (manufacturers.containsKey(device.getManufacturer())) {
                    devices = (List)manufacturers.get(device.getManufacturer());
                } else {
                    devices = new ArrayList();
                    manufacturers.put(device.getManufacturer(), devices);
                }
                devices.add(device);
            }
            ArrayList<Device> nexus = new ArrayList<Device>();
            EnumMap deviceMap = Maps.newEnumMap(FormFactor.class);
            for (FormFactor factor : FormFactor.values()) {
                deviceMap.put(factor, Lists.newArrayList());
            }
            for (List devices : manufacturers.values()) {
                for (Device device : devices) {
                    if (HardwareConfigHelper.isNexus((Device)device) && !device.getManufacturer().equals("Generic")) {
                        nexus.add(device);
                        continue;
                    }
                    ((List)deviceMap.get((Object)FormFactor.getFormFactor(device))).add(device);
                }
            }
            HardwareConfigHelper.sortNexusList(nexus);
            this.addNexusDeviceSection(group, current, nexus);
            group.addSeparator();
            this.addDeviceSection(group, current, deviceMap, false, FormFactor.WEAR);
            group.addSeparator();
            this.addDeviceSection(group, current, deviceMap, false, FormFactor.TV);
            group.addSeparator();
            DefaultActionGroup genericGroup = new DefaultActionGroup("_Generic Phones and Tablets", true);
            this.addDeviceSection(genericGroup, current, deviceMap, true, FormFactor.MOBILE);
            group.add((AnAction)genericGroup);
        }
        group.add((AnAction)new RunAndroidAvdManagerAction("Add Device Definition..."));
        group.addSeparator();
        if (RenderPreviewMode.getCurrent() != RenderPreviewMode.SCREENS) {
            ConfigurationMenuAction.addScreenSizeAction(this.myRenderContext, group);
        } else {
            ConfigurationMenuAction.addRemovePreviewsAction(this.myRenderContext, group);
        }
        return group;
    }

    private void addNexusDeviceSection(DefaultActionGroup group, Device current, List<Device> devices) {
        for (Device device : devices) {
            String label = this.getLabel(device, true);
            Icon icon = this.getDeviceClassIcon(device);
            group.add((AnAction)new SetDeviceAction(this.myRenderContext, label, device, icon, current == device));
        }
    }

    private void addDeviceSection(DefaultActionGroup group, Device current, Map<FormFactor, List<Device>> deviceMap, boolean reverse, FormFactor factor) {
        List<Device> generic = deviceMap.get((Object)factor);
        if (reverse) {
            Collections.reverse(generic);
        }
        for (Device device : generic) {
            String label = this.getLabel(device, false);
            Icon icon = this.getDeviceClassIcon(device);
            group.add((AnAction)new SetDeviceAction(this.myRenderContext, label, device, icon, current == device));
        }
    }

    private String getLabel(Device device, boolean isNexus) {
        VirtualFile better;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (better = ConfigurationMatcher.getBetterMatch(configuration, device, null, null, null)) != null) {
            return ConfigurationAction.getBetterMatchLabel(device.getDisplayName(), better, configuration.getFile());
        }
        return isNexus ? HardwareConfigHelper.getNexusLabel((Device)device) : HardwareConfigHelper.getGenericLabel((Device)device);
    }

    private class SetDeviceAction
    extends ConfigurationAction {
        private final Device myDevice;

        public SetDeviceAction(RenderContext renderContext, String title, Device device, Icon defaultIcon, boolean select) {
            super(renderContext, title);
            this.myDevice = device;
            if (select) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            } else if (ConfigurationAction.isBetterMatchLabel(title)) {
                this.getTemplatePresentation().setIcon(ConfigurationAction.getBetterMatchIcon());
            } else if (defaultIcon != null) {
                this.getTemplatePresentation().setIcon(defaultIcon);
            }
        }

        @Override
        protected void updatePresentation() {
            DeviceMenuAction.this.updatePresentation(DeviceMenuAction.this.getTemplatePresentation());
        }

        @Override
        protected void updateConfiguration(Configuration configuration, boolean commit) {
            String name;
            VirtualFile file;
            String newState;
            Device prevDevice = configuration.getDevice();
            State prevState = configuration.getDeviceState();
            String string = newState = prevState != null ? prevState.getName() : null;
            if (prevDevice != null && prevState != null && prevState.isDefaultState() && !this.myDevice.getDefaultState().getName().equals(prevState.getName()) && configuration.getEditedConfig().getScreenOrientationQualifier() == null && (file = configuration.getFile()) != null && ConfigurationMatcher.getBetterMatch(configuration, this.myDevice, name = this.myDevice.getDefaultState().getName(), null, null) == null) {
                newState = name;
            }
            if (newState != null) {
                configuration.setDeviceStateName(newState);
            }
            if (commit) {
                configuration.getConfigurationManager().selectDevice(this.myDevice);
            } else {
                configuration.setDevice(this.myDevice, true);
            }
        }
    }

    public static enum FormFactor {
        MOBILE,
        WEAR,
        GLASS,
        TV,
        CAR;

        private Icon myIcon64;

        public static FormFactor getFormFactor(Device device) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return WEAR;
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return TV;
            }
            return MOBILE;
        }

        public Icon getIcon() {
            switch (this) {
                case CAR: {
                    return AndroidIcons.FormFactors.Car_16;
                }
                case WEAR: {
                    return AndroidIcons.FormFactors.Wear_16;
                }
                case TV: {
                    return AndroidIcons.FormFactors.Tv_16;
                }
                case GLASS: {
                    return AndroidIcons.FormFactors.Glass_16;
                }
            }
            return AndroidIcons.FormFactors.Mobile_16;
        }

        public Icon getLargeIcon() {
            switch (this) {
                case CAR: {
                    return AndroidIcons.FormFactors.Car_128;
                }
                case WEAR: {
                    return AndroidIcons.FormFactors.Wear_128;
                }
                case TV: {
                    return AndroidIcons.FormFactors.Tv_128;
                }
                case GLASS: {
                    return AndroidIcons.FormFactors.Glass_128;
                }
            }
            return AndroidIcons.FormFactors.Mobile_128;
        }

        public boolean hasEmulator() {
            return this != GLASS;
        }

        public Icon getIcon64() {
            switch (this) {
                case CAR: {
                    return AndroidIcons.FormFactors.Car_64;
                }
                case WEAR: {
                    return AndroidIcons.FormFactors.Wear_64;
                }
                case TV: {
                    return AndroidIcons.FormFactors.Tv_64;
                }
                case GLASS: {
                    return AndroidIcons.FormFactors.Glass_64;
                }
            }
            return AndroidIcons.FormFactors.Mobile_64;
        }
    }
}

