/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import java.util.Locale;

public enum AvdScaleFactor {
    TEN_TO_ONE(10, 1, "0.1"),
    FOUR_TO_ONE(4, 1, "0.25"),
    TWO_TO_ONE(2, 1, "0.5"),
    ONE_TO_ONE(1, 1, "1"),
    ONE_TO_TWO(1, 2, "2"),
    ONE_TO_THREE(1, 3, "3"),
    AUTO("Auto", "auto");

    private final String myHumanReadableName;
    private final String myValue;

    public static AvdScaleFactor findByValue(String value) {
        for (AvdScaleFactor factor : AvdScaleFactor.values()) {
            if (!value.equals(factor.getValue())) continue;
            return factor;
        }
        return null;
    }

    private AvdScaleFactor(int deviceDp, int screenPixels, String value) {
        this.myHumanReadableName = String.format(Locale.getDefault(), "%ddp on device = %dpx on screen", deviceDp, screenPixels);
        this.myValue = value;
    }

    private AvdScaleFactor(String humanReadableName, String value) {
        this.myHumanReadableName = humanReadableName;
        this.myValue = value;
    }

    public String getValue() {
        return this.myValue;
    }

    public String toString() {
        return this.myHumanReadableName;
    }
}

