/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.npw.WizardUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class ShowLicensesUsedAction
extends DumbAwareAction {
    public ShowLicensesUsedAction() {
        super("Show Licenses...");
    }

    public void actionPerformed(AnActionEvent e) {
        LicenseDialog licenseDialog = new LicenseDialog(ShowLicensesUsedAction.getEventProject((AnActionEvent)e));
        licenseDialog.init();
        try {
            licenseDialog.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class LicenseDialog
    extends DialogWrapper {
        protected LicenseDialog(Project project) {
            super(project);
            this.getWindow().setMinimumSize((Dimension)JBUI.size((int)600, (int)400));
        }

        protected void init() {
            super.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            StringBuilder sb = new StringBuilder(5000);
            File licenseDir = new File(PathManager.getHomePath(), "license");
            assert (licenseDir.exists()) : licenseDir;
            LicenseDialog.collectLicenses(sb, licenseDir);
            File androidLicenses = new File(PathManager.getPreInstalledPluginsPath(), PathUtil.toSystemDependentName((String)"android/lib/licenses"));
            if (androidLicenses.exists() && androidLicenses.isDirectory()) {
                LicenseDialog.collectLicenses(sb, androidLicenses);
            }
            String text = "<html>" + sb.toString() + "</html>";
            JTextPane label = new JTextPane();
            label.setContentType("text/html");
            label.setText(text);
            JBScrollPane pane = new JBScrollPane((Component)label);
            pane.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
            panel.add((Component)pane, "Center");
            return panel;
        }

        private static void collectLicenses(StringBuilder sb, File licenseDir) {
            for (File file : WizardUtils.listFiles(licenseDir)) {
                sb.append("<br><br>------------ License file: ");
                sb.append(file.getName());
                sb.append("------------");
                sb.append("<br><br>");
                sb.append(LicenseDialog.getLicenseText(file));
            }
        }

        private static String getLicenseText(File f) {
            try {
                return Files.toString((File)f, (Charset)Charsets.UTF_8).replaceAll("\\<.*?\\>", "").replace("\n", "<br>");
            }
            catch (IOException e) {
                return "";
            }
        }
    }
}

