/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.NewAndroidActivityWizard;
import com.android.tools.idea.npw.ThemeHelper;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.io.File;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;

public class NewAndroidComponentAction
extends AnAction {
    public static Set<String> NEW_WIZARD_CATEGORIES = ImmutableSet.of((Object)"Activity", (Object)"Google");
    private final String myTemplateCategory;
    private final String myTemplateName;
    private final int myMinSdkVersion;
    private final boolean myRequireAppTheme;

    public NewAndroidComponentAction(String templateCategory, String templateName, TemplateMetadata metadata) {
        super(templateName, "Create a new " + templateName, null);
        this.myTemplateCategory = templateCategory;
        this.myTemplateName = templateName;
        if (this.isActivityTemplate()) {
            this.getTemplatePresentation().setIcon(AndroidIcons.Activity);
        } else {
            this.getTemplatePresentation().setIcon(AndroidIcons.AndroidFile);
        }
        if (metadata != null) {
            this.myMinSdkVersion = metadata.getMinSdk();
            this.myRequireAppTheme = metadata.isAppThemeRequired();
        } else {
            this.myMinSdkVersion = 0;
            this.myRequireAppTheme = false;
        }
    }

    private boolean isActivityTemplate() {
        return NEW_WIZARD_CATEGORIES.contains(this.myTemplateCategory);
    }

    public void update(AnActionEvent e) {
        ThemeHelper themeHelper;
        DataContext dataContext = e.getDataContext();
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(module);
        if (moduleInfo == null) {
            return;
        }
        Presentation presentation = e.getPresentation();
        int moduleMinSdkVersion = moduleInfo.getMinSdkVersion().getApiLevel();
        if (this.myMinSdkVersion > moduleMinSdkVersion) {
            presentation.setText(this.myTemplateName + " (Requires minSdk >= " + this.myMinSdkVersion + ")");
            presentation.setEnabled(false);
            return;
        }
        if (this.myRequireAppTheme && (themeHelper = new ThemeHelper(module)).getAppThemeName() == null) {
            presentation.setText(this.myTemplateName + " (No Application Theme Found)");
            presentation.setEnabled(false);
            return;
        }
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || facet.getAndroidModel() == null) {
            return;
        }
        VirtualFile targetFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        File file = TemplateManager.getInstance().getTemplateFile(this.myTemplateCategory, this.myTemplateName);
        NewAndroidActivityWizard wizard = new NewAndroidActivityWizard(module, targetFile, file);
        wizard.init();
        wizard.show();
    }
}

