/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.util.Projects;
import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;

public class AndroidActionGroupRemover
extends ActionGroup {
    private final ActionGroup myDelegate;

    public AndroidActionGroupRemover(ActionGroup delegate, String backupText) {
        super(delegate.getTemplatePresentation().getTextWithMnemonic(), delegate.getTemplatePresentation().getDescription(), delegate.getTemplatePresentation().getIcon());
        this.myDelegate = delegate;
        Presentation presentation = this.getTemplatePresentation();
        if (Strings.isNullOrEmpty((String)presentation.getText())) {
            presentation.setText(backupText);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        this.myDelegate.actionPerformed(e);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null && Projects.requiresAndroidModel(project)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        AndroidActionGroupRemover.updateTextAndIcon(this.getTemplatePresentation(), this.myDelegate.getTemplatePresentation());
        this.myDelegate.update(e);
    }

    public AnAction[] getChildren(AnActionEvent e) {
        return this.myDelegate.getChildren(e);
    }

    private static void updateTextAndIcon(Presentation source, Presentation destination) {
        destination.setText(source.getTextWithMnemonic());
        destination.setIcon(source.getIcon());
    }

    public boolean isPopup() {
        return this.myDelegate.isPopup();
    }
}

