/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.maven.compiler.MavenResourceFileProcessor;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceFileFilter;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsModuleOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class MavenWebArtifactRootCopyingHandlerProvider
extends ArtifactRootCopyingHandlerProvider {
    private static final Logger LOG = Logger.getInstance(MavenWebArtifactRootCopyingHandlerProvider.class);

    public FileCopyingHandler createCustomHandler(JpsArtifact artifact, File root, JpsPackagingElement contextElement, JpsModel model, BuildDataPaths buildDataPaths) {
        if (contextElement instanceof JpsModuleOutputPackagingElement) {
            return null;
        }
        MavenProjectConfiguration projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(buildDataPaths);
        if (projectConfiguration == null) {
            return null;
        }
        MavenWebArtifactConfiguration artifactResourceConfiguration = projectConfiguration.webArtifactConfigs.get(artifact.getName());
        if (artifactResourceConfiguration == null) {
            return null;
        }
        ResourceRootConfiguration rootConfiguration = artifactResourceConfiguration.getRootConfiguration(root);
        if (rootConfiguration == null) {
            return null;
        }
        MavenModuleResourceConfiguration moduleResourceConfiguration = projectConfiguration.moduleConfigurations.get(artifactResourceConfiguration.moduleName);
        if (moduleResourceConfiguration == null) {
            LOG.debug("Maven resource configuration not found for module " + artifactResourceConfiguration.moduleName);
            return null;
        }
        MavenResourceFileProcessor fileProcessor = new MavenResourceFileProcessor(projectConfiguration, model.getProject(), moduleResourceConfiguration);
        return new MavenWebRootCopyingHandler(fileProcessor, rootConfiguration, moduleResourceConfiguration, root);
    }

    private static class MavenWebRootCopyingHandler
    extends FileCopyingHandler {
        private final MavenResourceFileProcessor myFileProcessor;
        private final ResourceRootConfiguration myRootConfiguration;
        private final MavenModuleResourceConfiguration myModuleResourceConfiguration;
        private final File myRoot;
        private FileFilter myFileFilter;
        private boolean myMainWebAppRoot;

        private MavenWebRootCopyingHandler(MavenResourceFileProcessor fileProcessor, ResourceRootConfiguration rootConfiguration, MavenModuleResourceConfiguration moduleResourceConfiguration, File root) {
            this.myFileProcessor = fileProcessor;
            this.myRootConfiguration = rootConfiguration;
            this.myModuleResourceConfiguration = moduleResourceConfiguration;
            this.myRoot = root;
            this.myFileFilter = new MavenResourceFileFilter(this.myRoot, this.myRootConfiguration);
            String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)moduleResourceConfiguration.directory), (String)FileUtil.toSystemIndependentName((String)rootConfiguration.directory), (char)'/');
            this.myMainWebAppRoot = relativePath != null && "src/main/webapp".equals(StringUtil.trimEnd((String)relativePath, (String)"/"));
        }

        public void copyFile(File from, File to, CompileContext context) throws IOException {
            this.myFileProcessor.copyFile(from, to, this.myRootConfiguration, context, this.myMainWebAppRoot ? this.myFileFilter : FileUtilRt.ALL_FILES);
        }

        public void writeConfiguration(PrintWriter out) {
            out.print("maven hash:");
            out.println(this.myModuleResourceConfiguration.computeModuleConfigurationHash() + 31 * this.myRootConfiguration.computeConfigurationHash());
        }

        public FileFilter createFileFilter() {
            return this.myMainWebAppRoot ? FileUtilRt.ALL_FILES : this.myFileFilter;
        }
    }
}

