/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class XmlSchemaProvider {
    public static final ExtensionPointName<XmlSchemaProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.schemaProvider");

    public static XmlFile findSchema(String namespace, Module module, PsiFile file) {
        if (file.getProject().isDefault()) {
            return null;
        }
        boolean dumb = DumbService.getInstance(file.getProject()).isDumb();
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions(EP_NAME)) {
            XmlFile schema;
            if (dumb && !DumbService.isDumbAware(provider) || file instanceof XmlFile && !provider.isAvailable((XmlFile)file) || (schema = provider.getSchema(namespace, module, file)) == null) continue;
            return schema;
        }
        return null;
    }

    public static XmlFile findSchema(String namespace, PsiFile baseFile) {
        PsiDirectory directory = baseFile.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement(directory == null ? baseFile : directory);
        return XmlSchemaProvider.findSchema(namespace, module, baseFile);
    }

    @Deprecated
    public static XmlSchemaProvider getAvailableProvider(XmlFile file) {
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isAvailable(file)) continue;
            return provider;
        }
        return null;
    }

    public static List<XmlSchemaProvider> getAvailableProviders(final XmlFile file) {
        return ContainerUtil.findAll((Object[])Extensions.getExtensions(EP_NAME), (Condition)new Condition<XmlSchemaProvider>(){

            public boolean value(XmlSchemaProvider xmlSchemaProvider) {
                return xmlSchemaProvider.isAvailable(file);
            }
        });
    }

    public abstract XmlFile getSchema(String var1, Module var2, PsiFile var3);

    public boolean isAvailable(XmlFile file) {
        return false;
    }

    public Set<String> getAvailableNamespaces(XmlFile file, String tagName) {
        return Collections.emptySet();
    }

    public String getDefaultPrefix(String namespace, XmlFile context) {
        return null;
    }

    public Set<String> getLocations(String namespace, XmlFile context) {
        return null;
    }
}

