/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public abstract class XLineBreakpointType<P extends XBreakpointProperties>
extends XBreakpointType<XLineBreakpoint<P>, P> {
    protected XLineBreakpointType(String id, String title) {
        super(id, title);
    }

    public boolean canPutAt(VirtualFile file, int line, Project project) {
        return false;
    }

    public abstract P createBreakpointProperties(VirtualFile var1, int var2);

    @Override
    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        return XLineBreakpointType.fileLineDisplayText(breakpoint.getPresentableFilePath(), breakpoint.getLine());
    }

    private static String fileLineDisplayText(String path, int line) {
        return XDebuggerBundle.message("xbreakpoint.default.display.text", line + 1, path);
    }

    @Override
    public final XSourcePosition getSourcePosition(XBreakpoint<P> breakpoint) {
        return null;
    }

    @Override
    public String getShortText(XLineBreakpoint<P> breakpoint) {
        return XLineBreakpointType.fileLineDisplayText(breakpoint.getShortFilePath(), breakpoint.getLine());
    }

    @Override
    public final XLineBreakpoint<P> createDefaultBreakpoint(XBreakpointType.XBreakpointCreator<P> creator) {
        return null;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(XLineBreakpoint<P> breakpoint, XDebugSession currentSession) {
        return Collections.emptyList();
    }

    public Icon getTemporaryIcon() {
        return AllIcons.Debugger.Db_temporary_breakpoint;
    }

    public int getPriority() {
        return 0;
    }

    public boolean canBeHitInOtherPlaces() {
        return false;
    }
}

