/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Comparator;
import java.util.List;

public abstract class XDebuggerUtil {
    public static XDebuggerUtil getInstance() {
        return ServiceManager.getService(XDebuggerUtil.class);
    }

    public abstract XLineBreakpointType<?>[] getLineBreakpointTypes();

    public void toggleLineBreakpoint(Project project, VirtualFile file, int line) {
        this.toggleLineBreakpoint(project, file, line, false);
    }

    public abstract void toggleLineBreakpoint(Project var1, VirtualFile var2, int var3, boolean var4);

    public abstract boolean canPutBreakpointAt(Project var1, VirtualFile var2, int var3);

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(Project project, XLineBreakpointType<P> type, VirtualFile file, int line) {
        this.toggleLineBreakpoint(project, type, file, line, false);
    }

    public abstract <P extends XBreakpointProperties> void toggleLineBreakpoint(Project var1, XLineBreakpointType<P> var2, VirtualFile var3, int var4, boolean var5);

    public abstract void removeBreakpoint(Project var1, XBreakpoint<?> var2);

    public abstract <B extends XBreakpoint<?>> XBreakpointType<B, ?> findBreakpointType(Class<? extends XBreakpointType<B, ?>> var1);

    public abstract XSourcePosition createPosition(VirtualFile var1, int var2);

    public abstract XSourcePosition createPositionByOffset(VirtualFile var1, int var2);

    public abstract <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule();

    public abstract <B extends XLineBreakpoint<?>> List<XBreakpointGroupingRule<B, ?>> getGroupingByFileRuleAsList();

    public abstract <B extends XBreakpoint<?>> Comparator<B> getDefaultBreakpointComparator(XBreakpointType<B, ?> var1);

    public abstract <P extends XBreakpointProperties> Comparator<XLineBreakpoint<P>> getDefaultLineBreakpointComparator();

    public abstract <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> var1);

    public abstract XValueContainer getValueContainer(DataContext var1);

    public abstract void iterateLine(Project var1, Document var2, int var3, Processor<PsiElement> var4);

    public abstract void disableValueLookup(Editor var1);

    public abstract PsiElement findContextElement(VirtualFile var1, int var2, Project var3, boolean var4);

    public abstract XExpression createExpression(String var1, Language var2, String var3, EvaluationMode var4);
}

