/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.concurrency.Promise;

public abstract class XDebugProcess {
    private final XDebugSession mySession;
    private ProcessHandler myProcessHandler;

    protected XDebugProcess(XDebugSession session) {
        this.mySession = session;
    }

    public final XDebugSession getSession() {
        return this.mySession;
    }

    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        return XBreakpointHandler.EMPTY_ARRAY;
    }

    public abstract XDebuggerEditorsProvider getEditorsProvider();

    public void sessionInitialized() {
    }

    public void startPausing() {
    }

    public abstract void startStepOver();

    public void startForceStepInto() {
        this.startStepInto();
    }

    public abstract void startStepInto();

    public abstract void startStepOut();

    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return null;
    }

    public void stop() {
        throw new AbstractMethodError();
    }

    public Promise<Void> stopAsync() {
        this.stop();
        return Promise.DONE;
    }

    public abstract void resume();

    public abstract void runToPosition(XSourcePosition var1);

    public boolean checkCanPerformCommands() {
        return true;
    }

    public boolean checkCanInitBreakpoints() {
        return true;
    }

    protected ProcessHandler doGetProcessHandler() {
        return null;
    }

    public final ProcessHandler getProcessHandler() {
        if (this.myProcessHandler == null) {
            this.myProcessHandler = this.doGetProcessHandler();
            if (this.myProcessHandler == null) {
                this.myProcessHandler = new DefaultDebugProcessHandler();
            }
        }
        return this.myProcessHandler;
    }

    public ExecutionConsole createConsole() {
        return TextConsoleBuilderFactory.getInstance().createBuilder(this.getSession().getProject()).getConsole();
    }

    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return null;
    }

    @Deprecated
    public void registerAdditionalContent(RunnerLayoutUi ui) {
    }

    @Deprecated
    public void registerAdditionalActions(DefaultActionGroup leftToolbar, DefaultActionGroup topToolbar) {
    }

    public void registerAdditionalActions(DefaultActionGroup leftToolbar, DefaultActionGroup topToolbar, DefaultActionGroup settings) {
        this.registerAdditionalActions(leftToolbar, topToolbar);
    }

    public String getCurrentStateMessage() {
        return this.mySession.isStopped() ? XDebuggerBundle.message("debugger.state.message.disconnected", new Object[0]) : XDebuggerBundle.message("debugger.state.message.connected", new Object[0]);
    }

    public HyperlinkListener getCurrentStateHyperlinkListener() {
        return null;
    }

    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            @Override
            public void registerAdditionalContent(RunnerLayoutUi ui) {
                XDebugProcess.this.registerAdditionalContent(ui);
            }
        };
    }

    public boolean isValuesCustomSorted() {
        return false;
    }

    public XDebuggerEvaluator getEvaluator() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame == null ? null : frame.getEvaluator();
    }
}

