/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface VcsLogProvider {
    public DetailedLogData readFirstBlock(VirtualFile var1, Requirements var2) throws VcsException;

    public LogData readAllHashes(VirtualFile var1, Consumer<TimedVcsCommit> var2) throws VcsException;

    public List<? extends VcsShortCommitDetails> readShortDetails(VirtualFile var1, List<String> var2) throws VcsException;

    public List<? extends VcsFullCommitDetails> readFullDetails(VirtualFile var1, List<String> var2) throws VcsException;

    public VcsKey getSupportedVcs();

    public VcsLogRefManager getReferenceManager();

    public void subscribeToRootRefreshEvents(Collection<VirtualFile> var1, VcsLogRefresher var2);

    public List<TimedVcsCommit> getCommitsMatchingFilter(VirtualFile var1, VcsLogFilterCollection var2, int var3) throws VcsException;

    public VcsUser getCurrentUser(VirtualFile var1) throws VcsException;

    public Collection<String> getContainingBranches(VirtualFile var1, Hash var2) throws VcsException;

    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> var1);

    public static interface DetailedLogData {
        public List<VcsCommitMetadata> getCommits();

        public Set<VcsRef> getRefs();
    }

    public static interface LogData {
        public Set<VcsRef> getRefs();

        public Set<VcsUser> getUsers();
    }

    public static interface Requirements {
        public int getCommitCount();
    }
}

