/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.TypeChooser;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.lang.reflect.Type;
import javax.swing.Icon;

public abstract class DefaultAddAction<T extends DomElement>
extends AnAction {
    public DefaultAddAction() {
        super(ApplicationBundle.message("action.add", new Object[0]));
    }

    public DefaultAddAction(String text) {
        super(text);
    }

    public DefaultAddAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    protected Type getElementType() {
        return this.getDomCollectionChildDescription().getType();
    }

    protected void tuneNewValue(T t) {
    }

    protected abstract DomCollectionChildDescription getDomCollectionChildDescription();

    protected abstract DomElement getParentDomElement();

    protected void afterAddition(T newElement) {
    }

    @Override
    public final void actionPerformed(AnActionEvent e) {
        T result = this.performElementAddition();
        if (result != null) {
            this.afterAddition(result);
        }
    }

    protected T performElementAddition() {
        final DomElement parent = this.getParentDomElement();
        final DomManager domManager = parent.getManager();
        final TypeChooser[] oldChoosers = new TypeChooser[]{null};
        final Type[] aClass = new Type[]{null};
        StableElement result = (StableElement)new WriteCommandAction<StableElement<T>>(domManager.getProject(), new PsiFile[]{DomUtil.getFile(parent)}){

            @Override
            protected void run(Result<StableElement<T>> result) throws Throwable {
                DomElement parentDomElement = DefaultAddAction.this.getParentDomElement();
                DomElement t = DefaultAddAction.this.getDomCollectionChildDescription().addValue(parentDomElement, DefaultAddAction.this.getElementType());
                DefaultAddAction.this.tuneNewValue(t);
                aClass[0] = parent.getGenericInfo().getCollectionChildDescription(t.getXmlElementName()).getType();
                oldChoosers[0] = domManager.getTypeChooserManager().getTypeChooser(aClass[0]);
                final SmartPsiElementPointer<XmlTag> pointer = SmartPointerManager.getInstance(this.getProject()).createSmartPsiElementPointer(t.getXmlTag());
                domManager.getTypeChooserManager().registerTypeChooser(aClass[0], new TypeChooser(){

                    @Override
                    public Type chooseType(XmlTag tag) {
                        if (tag == pointer.getElement()) {
                            return DefaultAddAction.this.getElementType();
                        }
                        return oldChoosers[0].chooseType(tag);
                    }

                    @Override
                    public void distinguishTag(XmlTag tag, Type aClass) throws IncorrectOperationException {
                        oldChoosers[0].distinguishTag(tag, aClass);
                    }

                    @Override
                    public Type[] getChooserTypes() {
                        return oldChoosers[0].getChooserTypes();
                    }
                });
                result.setResult((StableElement)t.createStableCopy());
            }
        }.execute().getResultObject();
        if (result != null) {
            domManager.getTypeChooserManager().registerTypeChooser(aClass[0], oldChoosers[0]);
            return (T)((DomElement)result.getWrappedElement());
        }
        return null;
    }
}

