/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;

public class RemoveDomElementQuickFix
implements LocalQuickFix {
    private final boolean myIsTag;
    private final String myName;

    public RemoveDomElementQuickFix(DomElement element) {
        this.myIsTag = element.getXmlElement() instanceof XmlTag;
        this.myName = element.getXmlElementName();
    }

    @Override
    public String getName() {
        return this.myIsTag ? DomBundle.message("remove.element.fix.name", this.myName) : DomBundle.message("remove.attribute.fix.name", this.myName);
    }

    @Override
    public String getFamilyName() {
        return DomBundle.message("quick.fixes.family", new Object[0]);
    }

    @Override
    public void applyFix(Project project, ProblemDescriptor descriptor) {
        if (this.myIsTag) {
            XmlTag tag = (XmlTag)descriptor.getPsiElement();
            XmlTag parentTag = tag.getParentTag();
            DomElement domElement = DomManager.getDomManager(project).getDomElement(tag);
            assert (domElement != null);
            domElement.undefine();
            if (parentTag != null && parentTag.isValid()) {
                parentTag.collapseIfEmpty();
            }
        } else {
            GenericAttributeValue domElement = DomManager.getDomManager(project).getDomElement((XmlAttribute)descriptor.getPsiElement());
            assert (domElement != null);
            domElement.undefine();
        }
    }
}

