/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import javax.swing.Icon;

public class DomMetaData<T extends DomElement>
implements PsiWritableMetaData,
PsiPresentableMetaData,
PsiMetaData {
    private T myElement;
    private GenericDomValue myNameElement;

    @Override
    public final PsiElement getDeclaration() {
        return this.myElement.getXmlTag();
    }

    public T getElement() {
        return this.myElement;
    }

    @Override
    public String getName(PsiElement context) {
        return this.getName();
    }

    @Override
    public final String getName() {
        String s = ElementPresentationManager.getElementName(this.myElement);
        if (s != null) {
            return s;
        }
        GenericDomValue value = this.getNameElement(this.myElement);
        return value == null ? null : value.getStringValue();
    }

    @Override
    public void init(PsiElement element) {
        this.myElement = DomManager.getDomManager(element.getProject()).getDomElement((XmlTag)element);
        assert (this.myElement != null) : element;
        this.myNameElement = this.getNameElement(this.myElement);
    }

    public void setElement(T element) {
        this.myElement = element;
    }

    protected GenericDomValue getNameElement(T t) {
        return this.myElement.getGenericInfo().getNameDomElement((DomElement)t);
    }

    @Override
    public Object[] getDependences() {
        PsiElement declaration = this.getDeclaration();
        if (this.myElement != null && this.myElement.isValid()) {
            return new Object[]{DomUtil.getRoot(this.myElement), declaration};
        }
        return new Object[]{declaration};
    }

    @Override
    public void setName(String name) throws IncorrectOperationException {
        if (this.myNameElement != null) {
            this.myNameElement.setStringValue(name);
        }
    }

    @Override
    public String getTypeName() {
        return ElementPresentationManager.getTypeNameForObject(this.myElement);
    }

    @Override
    public Icon getIcon() {
        return ElementPresentationManager.getIcon(this.myElement);
    }
}

