/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.MappingClass;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ClassMappingNameConverter
extends ResolvingConverter.StringConverter {
    private static final Logger LOG = Logger.getInstance(ClassMappingNameConverter.class);

    @Override
    public Collection<String> getVariants(ConvertContext context) {
        PsiType type;
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        List<DomElement> children = DomUtil.getDefinedChildren(parent, true, true);
        DomElement classElement = (DomElement)ContainerUtil.find(children, (Condition)new Condition<DomElement>(){

            public boolean value(DomElement domElement) {
                return domElement.getAnnotation(MappingClass.class) != null;
            }
        });
        if (classElement == null) {
            return Collections.emptyList();
        }
        Object value = ((GenericDomValue)classElement).getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof PsiType) {
            type = (PsiType)value;
        } else if (value instanceof PsiClass) {
            type = PsiTypesUtil.getClassType((PsiClass)value);
        } else {
            LOG.error("wrong type: " + value.getClass());
            return Collections.emptyList();
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(context.getProject());
        SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type);
        return Arrays.asList(info.names);
    }

    @Override
    public PsiElement resolve(String o, ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        return parent.getXmlElement();
    }

    @Override
    public boolean isReferenceTo(PsiElement element, String stringValue, String resolveResult, ConvertContext context) {
        return element.getManager().areElementsEquivalent(element, this.resolve(stringValue, context));
    }
}

