/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.util.ui.update.ComparableObject;
import java.util.Arrays;

public abstract class Update
extends ComparableObject.Impl
implements Runnable,
Comparable {
    public static final int LOW_PRIORITY = 999;
    public static final int HIGH_PRIORITY = 10;
    private boolean myProcessed;
    private boolean myRejected;
    private final boolean myExecuteInWriteAction;
    private int myPriority = 999;

    public Update(Object identity) {
        this(identity, false);
    }

    public Update(Object identity, int priority) {
        this(identity, false, priority);
    }

    public Update(Object identity, boolean executeInWriteAction) {
        this(identity, executeInWriteAction, 999);
    }

    public Update(Object identity, boolean executeInWriteAction, int priority) {
        super(new Object[]{identity});
        this.myExecuteInWriteAction = executeInWriteAction;
        this.myPriority = priority;
    }

    public boolean isDisposed() {
        return false;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean wasProcessed() {
        return this.myProcessed;
    }

    public void setProcessed() {
        this.myProcessed = true;
    }

    public boolean executeInWriteAction() {
        return this.myExecuteInWriteAction;
    }

    public String toString() {
        return super.toString() + " Objects: " + Arrays.asList(this.getEqualityObjects());
    }

    public int compareTo(Object o) {
        int weightResult;
        Update another = (Update)o;
        int n = this.getPriority() < another.getPriority() ? -1 : (weightResult = this.getPriority() == another.getPriority() ? 0 : 1);
        if (weightResult == 0) {
            return this.equals(o) ? 0 : 1;
        }
        return weightResult;
    }

    public int getPriority() {
        return this.myPriority;
    }

    public boolean canEat(Update update) {
        return false;
    }

    public void setRejected() {
        this.myRejected = true;
    }

    public boolean isRejected() {
        return this.myRejected;
    }
}

