/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class Timer
implements Disposable,
Runnable {
    private final int mySpan;
    private final String myName;
    private volatile boolean myTakeInitialDelay = true;
    private Exception myInterruptedException;
    private final Object LOCK = new Object();
    private SharedThread mySharedThread;
    private ScheduledFuture<?> myFuture;
    private TimerState myState = TimerState.startup;
    private int myPauseTime;

    public Timer(String name, int span) {
        this.myName = name;
        this.mySpan = span;
        this.mySharedThread = SharedThread.getInstance();
    }

    public void setTakeInitialDelay(boolean take) {
        this.myTakeInitialDelay = take;
    }

    public final int getSpan() {
        return this.mySpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isRunning() || this.isDisposed()) {
                return;
            }
            this.myState = TimerState.startup;
            this.mySharedThread.queue(this, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.LOCK;
        synchronized (object) {
            switch (this.myState) {
                case startup: {
                    this.startup();
                    break;
                }
                case restarting: {
                    this.startup();
                    break;
                }
                case intialSleep: {
                    this.myState = TimerState.running;
                    this.fireAndReschedule();
                    break;
                }
                case running: {
                    this.fireAndReschedule();
                    break;
                }
                case suspended: {
                    break;
                }
                case pausing: {
                    this.myState = TimerState.running;
                    this.mySharedThread.queue(this, this.myPauseTime);
                    break;
                }
            }
        }
    }

    private void startup() {
        this.myState = TimerState.intialSleep;
        if (this.myTakeInitialDelay) {
            this.mySharedThread.queue(this, this.mySpan);
        } else {
            this.fireAndReschedule();
        }
    }

    private void fireAndReschedule() {
        try {
            this.onTimer();
        }
        catch (InterruptedException e) {
            this.myInterruptedException = e;
            this.suspend();
            return;
        }
        this.mySharedThread.queue(this, this.getSpan());
    }

    protected abstract void onTimer() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed() || !this.isRunning()) {
                return;
            }
            this.myState = TimerState.suspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delay(int length) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed() || !this.isRunning()) {
                return;
            }
            this.myState = TimerState.pausing;
            this.mySharedThread.queue(this, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed() || this.isRunning()) {
                return;
            }
            this.myState = TimerState.running;
            this.mySharedThread.queue(this, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myState = TimerState.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myState = TimerState.restarting;
            this.mySharedThread.queue(this, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myState == TimerState.running || this.myState == TimerState.intialSleep || this.myState == TimerState.restarting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myState == TimerState.disposed;
        }
    }

    public String toString() {
        return "Timer=" + this.myName;
    }

    private void setFuture(ScheduledFuture<?> schedule) {
        this.myFuture = schedule;
    }

    public ScheduledFuture<?> getFuture() {
        return this.myFuture;
    }

    private static class SharedThread {
        private final ScheduledThreadPoolExecutor myExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"AnimatorThread");
        private static SharedThread ourInstance;

        private SharedThread() {
        }

        public static SharedThread getInstance() {
            if (ourInstance == null) {
                ourInstance = new SharedThread();
            }
            return ourInstance;
        }

        public void queue(Timer timer, int span) {
            ScheduledFuture<?> future = timer.getFuture();
            if (future != null) {
                future.cancel(true);
            }
            timer.setFuture(this.myExecutor.schedule(timer, (long)span, TimeUnit.MILLISECONDS));
        }
    }

    static enum TimerState {
        startup,
        intialSleep,
        running,
        suspended,
        restarting,
        pausing,
        disposed;

    }
}

