/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.Alarm;

public final class TimedDeadzone {
    public static final Length DEFAULT = new Length(150);
    public static final Length NULL = new Length(-1);
    private Alarm myAlarm;
    private Length myLength = NULL;
    private boolean myWithin;
    private final Runnable myClear = new Runnable(){

        @Override
        public void run() {
            TimedDeadzone.this.clear();
        }
    };

    public TimedDeadzone(Length zoneLength, Alarm.ThreadToUse thread) {
        this.myLength = zoneLength;
        this.myAlarm = new Alarm(thread);
    }

    public TimedDeadzone(Length zoneLength) {
        this(zoneLength, Alarm.ThreadToUse.SWING_THREAD);
    }

    public int getLength() {
        return this.myLength.getLength();
    }

    public void enter() {
        if (!this.isWithin()) {
            this.reEnter();
        }
    }

    public void reEnter() {
        if (this.myLength == NULL) {
            this.clear();
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myWithin = true;
        this.myAlarm.addRequest(this.myClear, this.getLength());
    }

    public void clear() {
        this.myAlarm.cancelAllRequests();
        this.myWithin = false;
    }

    public boolean isWithin() {
        return this.myWithin;
    }

    public void setLength(Length deadZone) {
        this.myLength = deadZone;
    }

    public static class Length {
        private final int myLength;

        public Length(int length) {
            this.myLength = length;
        }

        public int getLength() {
            return this.myLength;
        }
    }
}

