/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.btr.proxy.search.ProxySearch;
import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.selector.pac.UrlPacScriptSource;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class IdeaWideProxySelector
extends ProxySelector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.net.IdeaWideProxySelector");
    private final HttpConfigurable myHttpConfigurable;
    private final AtomicReference<ProxySelector> myPacProxySelector = new AtomicReference();

    public IdeaWideProxySelector(HttpConfigurable configurable) {
        this.myHttpConfigurable = configurable;
    }

    @Override
    public List<Proxy> select(URI uri) {
        LOG.debug("IDEA-wide proxy selector asked for " + uri.toString());
        String scheme = uri.getScheme();
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            LOG.debug("No proxy: not http/https scheme: " + scheme);
            return CommonProxy.NO_PROXY_LIST;
        }
        if (this.myHttpConfigurable.USE_HTTP_PROXY) {
            if (this.isProxyException(uri)) {
                LOG.debug("No proxy: URI '", new Object[]{uri, "' matches proxy exceptions [", this.myHttpConfigurable.PROXY_EXCEPTIONS, "]"});
                return CommonProxy.NO_PROXY_LIST;
            }
            if (this.myHttpConfigurable.PROXY_PORT < 0 || this.myHttpConfigurable.PROXY_PORT > 65535) {
                LOG.debug("No proxy: invalid port: " + this.myHttpConfigurable.PROXY_PORT);
                return CommonProxy.NO_PROXY_LIST;
            }
            Proxy.Type type = this.myHttpConfigurable.PROXY_TYPE_IS_SOCKS ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
            Proxy proxy = new Proxy(type, new InetSocketAddress(this.myHttpConfigurable.PROXY_HOST, this.myHttpConfigurable.PROXY_PORT));
            LOG.debug("Defined proxy: ", new Object[]{proxy});
            this.myHttpConfigurable.LAST_ERROR = null;
            return Collections.singletonList(proxy);
        }
        if (this.myHttpConfigurable.USE_PROXY_PAC) {
            ProxySelector pacProxySelector = this.myPacProxySelector.get();
            if (this.myHttpConfigurable.USE_PAC_URL && !StringUtil.isEmpty((String)this.myHttpConfigurable.PAC_URL)) {
                this.myPacProxySelector.set((ProxySelector)new PacProxySelector((PacScriptSource)new UrlPacScriptSource(this.myHttpConfigurable.PAC_URL)));
            } else if (pacProxySelector == null) {
                ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
                proxySearch.setPacCacheSettings(32, 600000L);
                pacProxySelector = proxySearch.getProxySelector();
                this.myPacProxySelector.lazySet(pacProxySelector);
            }
            if (pacProxySelector != null) {
                List<Proxy> select = pacProxySelector.select(uri);
                LOG.debug("Autodetected proxies: ", new Object[]{select});
                return select;
            }
            LOG.debug("No proxies detected");
        }
        return CommonProxy.NO_PROXY_LIST;
    }

    private boolean isProxyException(URI uri) {
        String uriHost = uri.getHost();
        return this.isProxyException(uriHost);
    }

    public boolean isProxyException(String uriHost) {
        if (StringUtil.isEmptyOrSpaces((String)uriHost) || StringUtil.isEmptyOrSpaces((String)this.myHttpConfigurable.PROXY_EXCEPTIONS)) {
            return false;
        }
        List hosts = StringUtil.split((String)this.myHttpConfigurable.PROXY_EXCEPTIONS, (String)",");
        for (String hostPattern : hosts) {
            String regexpPattern = StringUtil.escapeToRegexp((String)hostPattern.trim()).replace("\\*", ".*");
            if (!Pattern.compile(regexpPattern).matcher(uriHost).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        InetSocketAddress isa;
        if (this.myHttpConfigurable.USE_PROXY_PAC) {
            this.myHttpConfigurable.removeGeneric(new CommonProxy.HostInfo(uri.getScheme(), uri.getHost(), uri.getPort()));
            LOG.debug("generic proxy credentials (if were saved) removed");
            return;
        }
        InetSocketAddress inetSocketAddress = isa = sa instanceof InetSocketAddress ? (InetSocketAddress)sa : null;
        if (this.myHttpConfigurable.USE_HTTP_PROXY && isa != null && Comparing.equal((String)this.myHttpConfigurable.PROXY_HOST, (String)isa.getHostName())) {
            LOG.debug("connection failed message passed to http configurable");
            this.myHttpConfigurable.LAST_ERROR = ioe.getMessage();
        }
    }
}

