/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexedRootsProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class IndexableSetContributor
implements IndexedRootsProvider {
    protected static final Set<VirtualFile> EMPTY_FILE_SET = Collections.unmodifiableSet(new HashSet());

    @Override
    public final Set<String> getRootsToIndex() {
        return ContainerUtil.map2Set(this.getAdditionalRootsToIndex(), (Function)new NotNullFunction<VirtualFile, String>(){

            public String fun(VirtualFile virtualFile) {
                return virtualFile.getUrl();
            }
        });
    }

    public static Set<VirtualFile> getProjectRootsToIndex(IndexedRootsProvider provider, Project project) {
        if (provider instanceof IndexableSetContributor) {
            return ((IndexableSetContributor)provider).getAdditionalProjectRootsToIndex(project);
        }
        return EMPTY_FILE_SET;
    }

    public static Set<VirtualFile> getRootsToIndex(IndexedRootsProvider provider) {
        if (provider instanceof IndexableSetContributor) {
            return ((IndexableSetContributor)provider).getAdditionalRootsToIndex();
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (String url : provider.getRootsToIndex()) {
            ContainerUtil.addIfNotNull((Object)VirtualFileManager.getInstance().findFileByUrl(url), result);
        }
        return result;
    }

    public Set<VirtualFile> getAdditionalProjectRootsToIndex(Project project) {
        return EMPTY_FILE_SET;
    }

    public abstract Set<VirtualFile> getAdditionalRootsToIndex();
}

