/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;

public class QueryFactory<Result, Parameters> {
    private final List<QueryExecutor<Result, Parameters>> myExecutors = ContainerUtil.createLockFreeCopyOnWriteList();

    public void registerExecutor(QueryExecutor<Result, Parameters> executor) {
        this.myExecutors.add(executor);
    }

    public void unregisterExecutor(QueryExecutor<Result, Parameters> executor) {
        this.myExecutors.remove(executor);
    }

    public final Query<Result> createQuery(Parameters parameters) {
        return new ExecutorsQuery(parameters, this.getExecutors());
    }

    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        return this.myExecutors;
    }

    public boolean hasAnyExecutors() {
        return !this.getExecutors().isEmpty();
    }

    public final Query<Result> createUniqueResultsQuery(Parameters parameters) {
        return new UniqueResultsQuery(this.createQuery(parameters));
    }

    public final Query<Result> createUniqueResultsQuery(Parameters parameters, TObjectHashingStrategy<Result> hashingStrategy) {
        return new UniqueResultsQuery<Result, Result>(this.createQuery(parameters), hashingStrategy);
    }

    public final <T> Query<Result> createUniqueResultsQuery(Parameters parameters, TObjectHashingStrategy<T> hashingStrategy, Function<Result, T> mapper) {
        return new UniqueResultsQuery<Result, T>(this.createQuery(parameters), hashingStrategy, mapper);
    }
}

