/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class InstanceofQuery<T>
implements Query<T> {
    private final Class<? extends T>[] myClasses;
    private final Query<?> myDelegate;

    public InstanceofQuery(Query<?> delegate, Class<? extends T> ... aClasses) {
        this.myClasses = aClasses;
        this.myDelegate = delegate;
    }

    @Override
    public Collection<T> findAll() {
        ArrayList result = new ArrayList();
        Collection<?> all = this.myDelegate.findAll();
        for (Object o : all) {
            for (Class<T> clazz : this.myClasses) {
                if (!clazz.isInstance(o)) continue;
                result.add(o);
            }
        }
        return result;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<T>)processor);
        return (T)processor.getFoundValue();
    }

    @Override
    public boolean forEach(Processor<T> consumer) {
        return this.myDelegate.forEach(new MyProcessor<T>(consumer));
    }

    @Override
    public AsyncFuture<Boolean> forEachAsync(Processor<T> consumer) {
        return this.myDelegate.forEachAsync(new MyProcessor<T>(consumer));
    }

    @Override
    public T[] toArray(T[] a) {
        Collection<T> all = this.findAll();
        return all.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator(this.findAll().iterator());
    }

    private class MyProcessor<T>
    implements Processor<T> {
        private final Processor<T> myConsumer;

        public MyProcessor(Processor<T> consumer) {
            this.myConsumer = consumer;
        }

        public boolean process(T o) {
            for (Class aClass : InstanceofQuery.this.myClasses) {
                if (!aClass.isInstance(o)) continue;
                return this.myConsumer.process(o);
            }
            return true;
        }
    }
}

