/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;

public class CollectionQuery<T>
implements Query<T> {
    private final Collection<T> myCollection;

    public CollectionQuery(Collection<T> collection) {
        this.myCollection = collection;
    }

    @Override
    public Collection<T> findAll() {
        return this.myCollection;
    }

    @Override
    public T findFirst() {
        Iterator<T> i = this.iterator();
        return i.hasNext() ? (T)i.next() : null;
    }

    @Override
    public boolean forEach(Processor<T> consumer) {
        return ContainerUtil.process(this.myCollection, consumer);
    }

    @Override
    public AsyncFuture<Boolean> forEachAsync(Processor<T> consumer) {
        return AsyncUtil.wrapBoolean(this.forEach(consumer));
    }

    @Override
    public T[] toArray(T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.myCollection.iterator();
    }
}

