/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ArrayQuery<T>
implements Query<T> {
    private final T[] myArray;

    public ArrayQuery(T ... array) {
        this.myArray = array;
    }

    @Override
    public Collection<T> findAll() {
        return Arrays.asList(this.myArray);
    }

    @Override
    public T findFirst() {
        return this.myArray.length > 0 ? (T)this.myArray[0] : null;
    }

    @Override
    public boolean forEach(Processor<T> consumer) {
        return ContainerUtil.process((Object[])this.myArray, consumer);
    }

    @Override
    public AsyncFuture<Boolean> forEachAsync(Processor<T> consumer) {
        return AsyncUtil.wrapBoolean(this.forEach(consumer));
    }

    @Override
    public T[] toArray(T[] a) {
        return this.myArray;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.myArray).iterator();
    }
}

