/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.ThrowableComputable;

public abstract class ActionRunner {
    public static void runInsideWriteAction(final InterruptibleRunnable runnable) throws Exception {
        RunResult result = new WriteAction(){

            @Override
            protected void run(Result result) throws Throwable {
                runnable.run();
            }
        }.execute();
        if (result.getThrowable() instanceof Exception) {
            throw (Exception)result.getThrowable();
        }
        result.throwException();
    }

    public static <T> T runInsideWriteAction(final InterruptibleRunnableWithResult<T> runnable) throws Exception {
        RunResult result = new WriteAction<T>(){

            @Override
            protected void run(Result<T> result) throws Throwable {
                result.setResult(runnable.run());
            }
        }.execute();
        if (result.getThrowable() instanceof Exception) {
            throw (Exception)result.getThrowable();
        }
        return result.throwException().getResultObject();
    }

    public static void runInsideReadAction(final InterruptibleRunnable runnable) throws Exception {
        ApplicationManager.getApplication().runReadAction(new ThrowableComputable<Void, Exception>(){

            public Void compute() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public static interface InterruptibleRunnableWithResult<T> {
        public T run() throws Exception;
    }

    public static interface InterruptibleRunnable {
        public void run() throws Exception;
    }
}

