/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractQuery<Result>
implements Query<Result> {
    private boolean myIsProcessing = false;

    @Override
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.forEach((Processor<Result>)processor);
        return processor.getResults();
    }

    @Override
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator(this.findAll().iterator());
    }

    @Override
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<Result>)processor);
        return (Result)processor.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (!this.myIsProcessing) : "Operation is not allowed while query is being processed";
    }

    @Override
    public Result[] toArray(Result[] a) {
        this.assertNotProcessing();
        Collection<Result> all = this.findAll();
        return all.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forEach(Processor<Result> consumer) {
        this.assertNotProcessing();
        this.myIsProcessing = true;
        try {
            boolean bl = this.processResults(consumer);
            return bl;
        }
        finally {
            this.myIsProcessing = false;
        }
    }

    @Override
    public AsyncFuture<Boolean> forEachAsync(Processor<Result> consumer) {
        return AsyncUtil.wrapBoolean(this.forEach(consumer));
    }

    protected abstract boolean processResults(Processor<Result> var1);

    protected AsyncFuture<Boolean> processResultsAsync(Processor<Result> consumer) {
        return AsyncUtil.wrapBoolean(this.processResults(consumer));
    }
}

