/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.impl.rules.ModuleGroupingRule;
import com.intellij.usages.impl.rules.NonCodeUsageGroupingRule;
import com.intellij.usages.impl.rules.UsageScopeGroupingRule;
import com.intellij.usages.impl.rules.UsageTypeGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class UsageGroupingRuleProviderImpl
implements UsageGroupingRuleProvider {
    protected boolean supportsNonCodeRule() {
        return true;
    }

    protected boolean supportsModuleRule() {
        return true;
    }

    protected boolean supportsScopesRule() {
        return true;
    }

    @Override
    public UsageGroupingRule[] getActiveRules(Project project) {
        ArrayList<UsageGroupingRule> rules = new ArrayList<UsageGroupingRule>();
        if (this.supportsNonCodeRule()) {
            rules.add(new NonCodeUsageGroupingRule(project));
        }
        if (this.supportsScopesRule() && UsageViewSettings.getInstance().GROUP_BY_SCOPE) {
            rules.add(new UsageScopeGroupingRule());
        }
        if (UsageViewSettings.getInstance().GROUP_BY_USAGE_TYPE) {
            rules.add(new UsageTypeGroupingRule());
        }
        if (this.supportsModuleRule() && UsageViewSettings.getInstance().GROUP_BY_MODULE) {
            rules.add(new ModuleGroupingRule());
        }
        if (UsageViewSettings.getInstance().GROUP_BY_PACKAGE) {
            rules.add(DirectoryGroupingRule.getInstance(project));
        }
        if (UsageViewSettings.getInstance().GROUP_BY_FILE_STRUCTURE) {
            FileStructureGroupRuleProvider[] providers;
            for (FileStructureGroupRuleProvider ruleProvider : providers = (FileStructureGroupRuleProvider[])Extensions.getExtensions(FileStructureGroupRuleProvider.EP_NAME)) {
                ContainerUtil.addIfNotNull(rules, (Object)ruleProvider.getUsageGroupingRule(project));
            }
        } else {
            rules.add(new FileGroupingRule(project));
        }
        return rules.toArray(new UsageGroupingRule[rules.size()]);
    }

    @Override
    public AnAction[] createGroupingActions(UsageView view) {
        GroupByModuleTypeAction groupByModuleTypeAction;
        UsageViewImpl impl = (UsageViewImpl)view;
        JComponent component = impl.getComponent();
        GroupByModuleTypeAction groupByModuleTypeAction2 = groupByModuleTypeAction = this.supportsModuleRule() ? new GroupByModuleTypeAction(impl) : null;
        if (groupByModuleTypeAction != null) {
            groupByModuleTypeAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(68, 128)), component, impl);
        }
        GroupByFileStructureAction groupByFileStructureAction = UsageGroupingRuleProviderImpl.createGroupByFileStructureAction(impl);
        GroupByScopeAction groupByScopeAction = this.supportsScopesRule() ? new GroupByScopeAction(impl) : null;
        GroupByPackageAction groupByPackageAction = new GroupByPackageAction(impl);
        groupByPackageAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(80, 128)), component, impl);
        ArrayList result = ContainerUtil.newArrayList();
        if (view.getPresentation().isUsageTypeFilteringAvailable()) {
            GroupByUsageTypeAction groupByUsageTypeAction = new GroupByUsageTypeAction(impl);
            groupByUsageTypeAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(84, 128)), component, impl);
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByUsageTypeAction);
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByScopeAction);
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByModuleTypeAction);
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByPackageAction);
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByFileStructureAction);
        } else {
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByScopeAction);
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByModuleTypeAction);
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByPackageAction);
            ContainerUtil.addIfNotNull((Collection)result, (Object)groupByFileStructureAction);
        }
        return result.toArray(new AnAction[result.size()]);
    }

    public static GroupByFileStructureAction createGroupByFileStructureAction(UsageViewImpl impl) {
        JComponent component = impl.getComponent();
        GroupByFileStructureAction groupByFileStructureAction = new GroupByFileStructureAction(impl);
        groupByFileStructureAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(77, 128)), component, impl);
        return groupByFileStructureAction;
    }

    private static class GroupByFileStructureAction
    extends RuleAction {
        private GroupByFileStructureAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.file.structure", new Object[0]), AllIcons.Actions.GroupByMethod);
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_FILE_STRUCTURE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_FILE_STRUCTURE = value;
        }
    }

    private static class GroupByPackageAction
    extends RuleAction {
        private GroupByPackageAction(UsageViewImpl view) {
            super(view, DirectoryGroupingRule.getInstance(view.getProject()).getActionTitle(), AllIcons.Actions.GroupByPackage);
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_PACKAGE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_PACKAGE = value;
        }
    }

    private static class GroupByModuleTypeAction
    extends RuleAction {
        private GroupByModuleTypeAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.module", new Object[0]), AllIcons.Actions.GroupByModule);
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_MODULE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_MODULE = value;
        }
    }

    private static class GroupByScopeAction
    extends RuleAction {
        private GroupByScopeAction(UsageViewImpl view) {
            super(view, "Group by test/production", AllIcons.Actions.GroupByTestProduction);
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_SCOPE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_SCOPE = value;
        }
    }

    private static class GroupByUsageTypeAction
    extends RuleAction {
        private GroupByUsageTypeAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.usage.type", new Object[0]), AllIcons.General.Filter);
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_USAGE_TYPE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_USAGE_TYPE = value;
        }
    }
}

