/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.filtered;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.PatchedDefaultMutableTreeNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FilteringTreeBuilder
extends AbstractTreeBuilder {
    private Object myLastSuccessfulSelect;
    private final Tree myTree;
    private MergingUpdateQueue myRefilterQueue;

    public FilteringTreeBuilder(Tree tree, ElementFilter filter, AbstractTreeStructure structure, Comparator<NodeDescriptor> comparator) {
        super(tree, (DefaultTreeModel)tree.getModel(), structure instanceof FilteringTreeStructure ? structure : new FilteringTreeStructure(filter, structure), comparator);
        this.myTree = tree;
        this.initRootNode();
        if (filter instanceof ElementFilter.Active) {
            ((ElementFilter.Active)filter).addListener(new ElementFilter.Listener(){

                public ActionCallback update(Object preferredSelection, boolean adjustSelection, boolean now) {
                    return FilteringTreeBuilder.this.refilter(preferredSelection, adjustSelection, now);
                }
            }, this);
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object element;
                TreePath newPath = e.getNewLeadSelectionPath();
                if (newPath != null && (element = FilteringTreeBuilder.this.getElementFor(newPath.getLastPathComponent())) != null) {
                    FilteringTreeBuilder.this.myLastSuccessfulSelect = element;
                }
            }
        });
    }

    @Override
    public boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return false;
    }

    @Override
    public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return true;
    }

    protected final DefaultMutableTreeNode createChildNode(NodeDescriptor childDescr) {
        return new PatchedDefaultMutableTreeNode(childDescr);
    }

    public void setFilteringMerge(int gap, JComponent modalityStateComponent) {
        if (this.myRefilterQueue != null) {
            Disposer.dispose((Disposable)this.myRefilterQueue);
            this.myRefilterQueue = null;
        }
        if (gap >= 0) {
            JComponent stateComponent = modalityStateComponent;
            if (stateComponent == null) {
                stateComponent = this.myTree;
            }
            this.myRefilterQueue = new MergingUpdateQueue("FilteringTreeBuilder", gap, false, stateComponent, this, this.myTree);
            this.myRefilterQueue.setRestartTimerOnAdd(true);
        }
    }

    protected boolean isSelectable(Object nodeObject) {
        return true;
    }

    public ActionCallback refilter() {
        return this.refilter(null, true, false);
    }

    public ActionCallback refilter(final Object preferredSelection, final boolean adjustSelection, final boolean now) {
        if (this.myRefilterQueue != null) {
            this.myRefilterQueue.cancelAllUpdates();
        }
        final ActionCallback callback = new ActionCallback();
        Runnable afterCancelUpdate = new Runnable(){

            @Override
            public void run() {
                if (FilteringTreeBuilder.this.myRefilterQueue == null || now) {
                    FilteringTreeBuilder.this.refilterNow(preferredSelection, adjustSelection).doWhenDone(callback.createSetDoneRunnable());
                } else {
                    FilteringTreeBuilder.this.myRefilterQueue.queue(new Update(this){

                        @Override
                        public void run() {
                            FilteringTreeBuilder.this.refilterNow(preferredSelection, adjustSelection).notifyWhenDone(callback);
                        }

                        @Override
                        public void setRejected() {
                            super.setRejected();
                            callback.setDone();
                        }
                    });
                }
            }
        };
        if (!this.isDisposed()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.getUi().cancelUpdate().doWhenProcessed(afterCancelUpdate);
            } else {
                afterCancelUpdate.run();
            }
        }
        return callback;
    }

    protected ActionCallback refilterNow(final Object preferredSelection, final boolean adjustSelection) {
        final ActionCallback selectionDone = new ActionCallback();
        this.getFilteredStructure().refilter();
        this.getUi().updateSubtree(this.getRootNode(), false);
        Runnable selectionRunnable = new Runnable(){

            @Override
            public void run() {
                Object toSelect;
                FilteringTreeBuilder.this.revalidateTree();
                Object object = toSelect = preferredSelection != null ? preferredSelection : FilteringTreeBuilder.this.myLastSuccessfulSelect;
                if (adjustSelection && toSelect != null) {
                    final FilteringTreeStructure.FilteringNode nodeToSelect = FilteringTreeBuilder.this.getFilteredStructure().getVisibleNodeFor(toSelect);
                    if (nodeToSelect != null) {
                        FilteringTreeBuilder.this.select(nodeToSelect, new Runnable(){

                            @Override
                            public void run() {
                                if (FilteringTreeBuilder.this.getSelectedElements().contains(nodeToSelect)) {
                                    FilteringTreeBuilder.this.myLastSuccessfulSelect = FilteringTreeBuilder.this.getOriginalNode(nodeToSelect);
                                }
                                selectionDone.setDone();
                            }
                        });
                    } else {
                        TreeUtil.ensureSelection(FilteringTreeBuilder.this.myTree);
                        selectionDone.setDone();
                    }
                } else {
                    selectionDone.setDone();
                }
            }
        };
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.queueUpdate().doWhenProcessed(selectionRunnable);
        } else {
            selectionRunnable.run();
        }
        final ActionCallback result = new ActionCallback();
        selectionDone.doWhenDone(new Runnable(){

            @Override
            public void run() {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    FilteringTreeBuilder.this.scrollSelectionToVisible(new Runnable(){

                        @Override
                        public void run() {
                            FilteringTreeBuilder.this.getReady(this).notify(result);
                        }
                    }, false);
                } else {
                    result.setDone();
                }
            }
        }).notifyWhenRejected(result);
        return result;
    }

    public void revalidateTree() {
        FilteringTreeBuilder.revalidateTree(this.myTree);
    }

    public static void revalidateTree(Tree tree) {
        tree.invalidate();
        tree.setRowHeight(tree.getRowHeight() == -1 ? -2 : -1);
        tree.revalidate();
        tree.repaint();
    }

    private FilteringTreeStructure getFilteredStructure() {
        return (FilteringTreeStructure)this.getTreeStructure();
    }

    private boolean isSimpleTree() {
        return this.myTree instanceof SimpleTree;
    }

    private Object getSelected() {
        if (this.isSimpleTree()) {
            FilteringTreeStructure.FilteringNode selected = (FilteringTreeStructure.FilteringNode)((SimpleTree)this.myTree).getSelectedNode();
            return selected != null ? selected.getDelegate() : null;
        }
        Object[] nodes = this.myTree.getSelectedNodes(Object.class, null);
        return nodes.length > 0 ? nodes[0] : null;
    }

    public FilteringTreeStructure.FilteringNode getVisibleNodeFor(Object nodeObject) {
        FilteringTreeStructure structure = this.getFilteredStructure();
        return structure != null ? structure.getVisibleNodeFor(nodeObject) : null;
    }

    public Object getOriginalNode(Object node) {
        return ((FilteringTreeStructure.FilteringNode)node).getDelegate();
    }

    @Override
    protected Object transformElement(Object object) {
        return this.getOriginalNode(object);
    }

    public Object getElementFor(Object node) {
        return this.getUi().getElementFor(node);
    }
}

