/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Function;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ListWithFilter<T>
extends JPanel
implements DataProvider {
    private final JList myList;
    private final SearchTextField mySearchField = new SearchTextField(false);
    private final NameFilteringListModel<T> myModel;
    private final JScrollPane myScroller;
    private final MySpeedSearch mySpeedSearch;

    @Override
    public Object getData(String dataId) {
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchField.getText();
        }
        return null;
    }

    public static boolean isSearchActive(JList list) {
        ListWithFilter listWithFilter = (ListWithFilter)UIUtil.getParentOfType(ListWithFilter.class, (Component)list);
        return listWithFilter != null && listWithFilter.mySpeedSearch.searchFieldShown;
    }

    public static JComponent wrap(JList list) {
        return ListWithFilter.wrap(list, ScrollPaneFactory.createScrollPane(list), StringUtil.createToStringFunction(Object.class));
    }

    public static <T> JComponent wrap(JList list, JScrollPane scroller, Function<T, String> namer) {
        return new ListWithFilter<T>(list, scroller, namer);
    }

    private ListWithFilter(JList list, JScrollPane scroller, Function<T, String> namer) {
        super(new BorderLayout());
        if (list instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)((Object)list)).getEmptyText().setText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
        }
        this.myList = list;
        this.myScroller = scroller;
        this.mySearchField.getTextEditor().setFocusable(false);
        this.mySearchField.setVisible(false);
        this.add((Component)this.mySearchField, "North");
        this.add((Component)this.myScroller, "Center");
        this.mySpeedSearch = new MySpeedSearch();
        this.mySpeedSearch.setEnabled(namer != null);
        this.myList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 65 && (e.isControlDown() || e.isMetaDown())) {
                    return;
                }
                ListWithFilter.this.mySpeedSearch.process(e);
            }
        });
        int selectedIndex = this.myList.getSelectedIndex();
        int modelSize = this.myList.getModel().getSize();
        this.myModel = new NameFilteringListModel<T>(this.myList, namer, new Condition<String>(){

            public boolean value(String s) {
                return ListWithFilter.this.mySpeedSearch.shouldBeShowing(s);
            }
        }, this.mySpeedSearch);
        if (this.myModel.getSize() == modelSize) {
            this.myList.setSelectedIndex(selectedIndex);
        }
        this.setBackground(list.getBackground());
    }

    public boolean resetFilter() {
        boolean hadPattern = this.mySpeedSearch.isHoldingFilter();
        if (this.mySearchField.isVisible()) {
            this.mySpeedSearch.reset();
        }
        return hadPattern;
    }

    public SpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    protected void onSpeedSearchPatternChanged() {
        Object prevSelection = this.myList.getSelectedValue();
        this.myModel.refilter();
        if (this.myModel.getSize() > 0) {
            int fullMatchIndex;
            int n = fullMatchIndex = this.mySpeedSearch.isHoldingFilter() ? this.myModel.getClosestMatchIndex() : this.myModel.getElementIndex(prevSelection);
            if (fullMatchIndex != -1) {
                this.myList.setSelectedIndex(fullMatchIndex);
            }
            if (this.myModel.getSize() <= this.myList.getSelectedIndex() || !this.myModel.contains(this.myList.getSelectedValue())) {
                this.myList.setSelectedIndex(0);
            }
        } else {
            this.mySearchField.getTextEditor().setBackground(LightColors.RED);
            this.revalidate();
        }
    }

    public JList getList() {
        return this.myList;
    }

    public JScrollPane getScrollPane() {
        return this.myScroller;
    }

    @Override
    public void requestFocus() {
        this.myList.requestFocus();
    }

    private class MySpeedSearch
    extends SpeedSearch {
        boolean searchFieldShown;
        boolean myInUpdate;

        private MySpeedSearch() {
            ListWithFilter.this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (MySpeedSearch.this.myInUpdate) {
                        return;
                    }
                    if (ListWithFilter.this.mySearchField.getText().isEmpty()) {
                        ListWithFilter.this.mySpeedSearch.reset();
                    }
                }
            });
        }

        @Override
        public void update() {
            this.myInUpdate = true;
            ListWithFilter.this.mySearchField.getTextEditor().setBackground(UIUtil.getTextFieldBackground());
            ListWithFilter.this.onSpeedSearchPatternChanged();
            ListWithFilter.this.mySearchField.setText(this.getFilter());
            if (this.isHoldingFilter() && !this.searchFieldShown) {
                ListWithFilter.this.mySearchField.setVisible(true);
                this.searchFieldShown = true;
            } else if (!this.isHoldingFilter() && this.searchFieldShown) {
                ListWithFilter.this.mySearchField.setVisible(false);
                this.searchFieldShown = false;
            }
            this.myInUpdate = false;
            this.revalidate();
        }

        private void revalidate() {
            JBPopup popup = PopupUtil.getPopupContainerFor(ListWithFilter.this.mySearchField);
            if (popup != null) {
                popup.pack(false, true);
            }
            ListWithFilter.this.revalidate();
        }
    }
}

