/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.navigation;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.navigation.History;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class Place
implements ComparableObject {
    private LinkedHashMap<String, Object> myPath = new LinkedHashMap();

    public final Object[] getEqualityObjects() {
        return new Object[]{this.myPath};
    }

    public final boolean equals(Object obj) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)obj);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    public Place putPath(String name, Object value) {
        this.myPath.put(name, value);
        return this;
    }

    public Object getPath(String name) {
        return this.myPath.get(name);
    }

    public Place cloneForElement(String name, Object value) {
        Place clone = new Place();
        clone.myPath = (LinkedHashMap)this.myPath.clone();
        clone.myPath.put(name, value);
        return clone;
    }

    public void copyFrom(Place from) {
        this.myPath = (LinkedHashMap)from.myPath.clone();
    }

    public boolean isMoreGeneralFor(Place place) {
        if (this.myPath.size() >= place.myPath.size()) {
            return false;
        }
        Iterator<String> thisIterator = this.myPath.keySet().iterator();
        Iterator<String> otherIterator = place.myPath.keySet().iterator();
        while (thisIterator.hasNext()) {
            String thisKey = thisIterator.next();
            String otherKey = otherIterator.next();
            if (thisKey == null || !thisKey.equals(otherKey)) {
                return false;
            }
            Object thisValue = this.myPath.get(thisKey);
            Object otherValue = place.myPath.get(otherKey);
            if (thisValue != null && thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public static ActionCallback goFurther(Object object, Place place, boolean requestFocus) {
        if (object instanceof Navigator) {
            return ((Navigator)object).navigateTo(place, requestFocus);
        }
        return new ActionCallback.Done();
    }

    public static void queryFurther(Object object, Place place) {
        if (object instanceof Navigator) {
            ((Navigator)object).queryPlace(place);
        }
    }

    public static interface Navigator {
        public void setHistory(History var1);

        public ActionCallback navigateTo(Place var1, boolean var2);

        public void queryPlace(Place var1);
    }
}

