/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.ui.TypingTarget;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.ui.components.ZoomingDelegate;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;

public class JBViewport
extends JViewport
implements ZoomableViewport {
    private static final ViewportLayout ourLayoutManager = new ViewportLayout(){

        @Override
        public void layoutContainer(Container parent) {
            JBViewport viewport = (JBViewport)parent;
            Component view = viewport.getView();
            JBScrollPane scrollPane = (JBScrollPane)UIUtil.getParentOfType(JBScrollPane.class, (Component)parent);
            if (view == null || scrollPane == null || view instanceof TypingTarget) {
                super.layoutContainer(parent);
                return;
            }
            Dimension size = this.doSuperLayoutContainer(viewport);
            Dimension visible = viewport.getExtentSize();
            if (scrollPane.getHorizontalScrollBarPolicy() == 31) {
                size.width = visible.width;
            }
            if (scrollPane.getVerticalScrollBarPolicy() == 21) {
                size.height = visible.height;
            }
            viewport.setViewSize(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension doSuperLayoutContainer(JBViewport viewport) {
            try {
                viewport.mySaveTempViewSize = true;
                super.layoutContainer(viewport);
            }
            finally {
                viewport.mySaveTempViewSize = false;
            }
            return viewport.myTempViewSize;
        }
    };
    private StatusText myEmptyText;
    private boolean myPaintingNow;
    private ZoomingDelegate myZoomer;
    private Dimension myTempViewSize;
    private boolean mySaveTempViewSize;

    public JBViewport() {
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JBTable) {
                    JBViewport.this.myEmptyText = ((ComponentWithEmptyText)((Object)child)).getEmptyText();
                    JBViewport.this.myEmptyText.attachTo(JBViewport.this, child);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JBTable) {
                    ((ComponentWithEmptyText)((Object)child)).getEmptyText().attachTo(child);
                    JBViewport.this.myEmptyText = null;
                }
            }
        });
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return ourLayoutManager;
    }

    @Override
    public void setViewSize(Dimension newSize) {
        if (this.mySaveTempViewSize) {
            this.myTempViewSize = newSize;
        } else {
            super.setViewSize(newSize);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.myPaintingNow = true;
        if (this.myZoomer != null && this.myZoomer.isActive()) {
            this.myZoomer.paint(g);
        } else {
            super.paint(g);
            if (this.myEmptyText != null) {
                this.myEmptyText.paint(this, g);
            }
        }
        this.myPaintingNow = false;
    }

    @Override
    public Magnificator getMagnificator() {
        JComponent view = (JComponent)this.getView();
        return view != null ? (Magnificator)UIUtil.getClientProperty((JComponent)view, Magnificator.CLIENT_PROPERTY_KEY) : null;
    }

    @Override
    public void magnificationStarted(Point at) {
        this.myZoomer = new ZoomingDelegate((JComponent)this.getView(), this);
        this.myZoomer.magnificationStarted(at);
    }

    @Override
    public void magnificationFinished(double magnification) {
        this.myZoomer.magnificationFinished(magnification);
        this.myZoomer = null;
    }

    @Override
    public void magnify(double magnification) {
        this.myZoomer.magnify(magnification);
    }

    public boolean isPaintingNow() {
        return this.myPaintingNow;
    }
}

