/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.border.LineBorder;

public class RoundedLineBorder
extends LineBorder {
    private int myArcSize = 1;

    public RoundedLineBorder(Color color) {
        super(color);
    }

    public RoundedLineBorder(Color color, int arcSize) {
        this(color, arcSize, 1);
    }

    public RoundedLineBorder(Color color, int arcSize, int thickness) {
        super(color, thickness);
        this.myArcSize = arcSize;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        Object oldAntialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g2.getColor();
        g2.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            g2.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, this.myArcSize, this.myArcSize);
        }
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
    }

    public void setColor(Color color) {
        this.lineColor = color;
    }
}

