/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BinaryLightVirtualFile
extends LightVirtualFileBase {
    private byte[] myContent = ArrayUtil.EMPTY_BYTE_ARRAY;

    public BinaryLightVirtualFile() {
        this("");
    }

    public BinaryLightVirtualFile(String name) {
        this(name, ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public BinaryLightVirtualFile(String name, byte[] content) {
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(String name, FileType fileType, byte[] content) {
        this(name, fileType, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(VirtualFile original, byte[] content, long modificationStamp) {
        this(original.getName(), original.getFileType(), content, modificationStamp);
    }

    public BinaryLightVirtualFile(String name, FileType fileType, byte[] content, long modificationStamp) {
        super(name, fileType, modificationStamp);
        this.setContent(content);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.myContent, this);
    }

    @Override
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        return VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                BinaryLightVirtualFile.this.setModificationStamp(newModificationStamp);
                byte[] content = this.toByteArray();
                BinaryLightVirtualFile.this.setContent(content);
            }
        }, this);
    }

    @Override
    public byte[] contentsToByteArray() throws IOException {
        return this.myContent;
    }

    public void setContent(Object requestor, byte[] content, boolean fireEvent) {
        this.setContent(content);
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    private void setContent(byte[] content) {
        this.myContent = content;
    }

    public byte[] getContent() {
        return this.myContent;
    }

    @Override
    public String toString() {
        return "BinaryLightVirtualFile: " + this.getPresentableUrl();
    }
}

